/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.hash.replication.RemoteNodeValidator;
import net.openhft.chronicle.hash.replication.ReplicationHub;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import net.openhft.chronicle.map.AddressAndPort;
import net.openhft.chronicle.map.ConcurrentExpiryMap;
import net.openhft.chronicle.map.DiscoveryNodeBytesMarshallable;
import net.openhft.chronicle.map.KnownNodes;
import net.openhft.chronicle.map.NodeDiscoveryBroadcaster;
import net.openhft.chronicle.map.NodeDiscoveryEventListener;
import net.openhft.chronicle.map.ReplicationHubFindByName;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import org.jetbrains.annotations.NotNull;

class NodeDiscovery {
    public static final int DEFAULT_UDP_BROADCAST_PORT = 8129;
    public static final short DEFAULT_TCP_PORT = 8123;
    public static final int SERIALIZED_ENTRY_SIZE = 1024;
    private final AddressAndPort ourAddressAndPort;
    private final UdpTransportConfig udpConfig;
    public static final InetAddress IP_MULIT_CAST_GROUP;
    private final DiscoveryNodeBytesMarshallable discoveryNodeBytesMarshallable;
    private final AtomicReference<NodeDiscoveryEventListener> nodeDiscoveryEventListenerAtomicReference = new AtomicReference();
    private KnownNodes knownNodes;

    public NodeDiscovery() throws IOException {
        this(8129, 8123, ConcurrentExpiryMap.getDefaultAddress(), IP_MULIT_CAST_GROUP);
    }

    public NodeDiscovery(short udpBroadcastPort, short tcpPort, @NotNull InetAddress tcpAddress, @NotNull InetAddress udpMultiCastGroup) throws IOException {
        this.ourAddressAndPort = new AddressAndPort(tcpAddress.getAddress(), tcpPort);
        this.udpConfig = UdpTransportConfig.multiCast(udpMultiCastGroup, udpBroadcastPort, ConcurrentExpiryMap.defaultNetworkInterface());
        this.knownNodes = new KnownNodes();
        this.discoveryNodeBytesMarshallable = new DiscoveryNodeBytesMarshallable(this.knownNodes, this.nodeDiscoveryEventListenerAtomicReference, this.ourAddressAndPort);
        NodeDiscoveryBroadcaster nodeDiscoveryBroadcaster = new NodeDiscoveryBroadcaster(this.udpConfig, 1024, this.discoveryNodeBytesMarshallable);
        this.discoveryNodeBytesMarshallable.setModificationNotifier(nodeDiscoveryBroadcaster);
    }

    public synchronized ReplicationHubFindByName mapByName() throws IOException, InterruptedException {
        byte identifier;
        ConcurrentSkipListSet knownHostPorts;
        block5: {
            AtomicInteger ourProposedIdentifier = new AtomicInteger();
            AtomicBoolean useAnotherIdentifier = new AtomicBoolean();
            knownHostPorts = new ConcurrentSkipListSet();
            ATSDirectBitSet knownAndProposedIdentifiers = new ATSDirectBitSet((Bytes)new ByteBufferBytes(ByteBuffer.allocate(16)));
            AtomicReference<CountDownLatch> countDownLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
            NodeDiscoveryEventListener nodeDiscoveryEventListener = new NodeDiscoveryEventListener((DirectBitSet)knownAndProposedIdentifiers, ourProposedIdentifier, useAnotherIdentifier, countDownLatch){
                final /* synthetic */ DirectBitSet val$knownAndProposedIdentifiers;
                final /* synthetic */ AtomicInteger val$ourProposedIdentifier;
                final /* synthetic */ AtomicBoolean val$useAnotherIdentifier;
                final /* synthetic */ AtomicReference val$countDownLatch;
                {
                    this.val$knownAndProposedIdentifiers = directBitSet;
                    this.val$ourProposedIdentifier = atomicInteger;
                    this.val$useAnotherIdentifier = atomicBoolean;
                    this.val$countDownLatch = atomicReference;
                }

                @Override
                public void onRemoteNodeEvent(@NotNull KnownNodes remoteNodes, @NotNull ConcurrentExpiryMap<AddressAndPort, DiscoveryNodeBytesMarshallable.ProposedNodes> proposedIdentifiersWithHost) {
                    NodeDiscoveryBroadcaster.LOG.info("onRemoteNodeEvent " + remoteNodes + ", proposedIdentifiersWithHost=" + proposedIdentifiersWithHost);
                    knownHostPorts.addAll(remoteNodes.addressAndPorts());
                    NodeDiscovery.this.orBitSets(remoteNodes.identifiers(), this.val$knownAndProposedIdentifiers);
                    for (DiscoveryNodeBytesMarshallable.ProposedNodes proposedIdentifierWithHost : proposedIdentifiersWithHost.values()) {
                        if (proposedIdentifierWithHost.addressAndPort().equals(NodeDiscovery.this.ourAddressAndPort)) continue;
                        byte proposedIdentifier = proposedIdentifierWithHost.identifier();
                        if (proposedIdentifier != -1) {
                            this.val$knownAndProposedIdentifiers.set((long)proposedIdentifier, true);
                        }
                        knownHostPorts.add(proposedIdentifierWithHost.addressAndPort());
                        if (proposedIdentifier != this.val$ourProposedIdentifier.get()) continue;
                        this.val$useAnotherIdentifier.set(true);
                    }
                    ((CountDownLatch)this.val$countDownLatch.get()).countDown();
                }
            };
            this.nodeDiscoveryEventListenerAtomicReference.set(nodeDiscoveryEventListener);
            DiscoveryNodeBytesMarshallable.ProposedNodes ourHostPort = new DiscoveryNodeBytesMarshallable.ProposedNodes(this.ourAddressAndPort, -1);
            for (int i = 0; i < 10; ++i) {
                this.discoveryNodeBytesMarshallable.sendBootStrap(ourHostPort);
                if (countDownLatch.get().await(i * 20, TimeUnit.MILLISECONDS)) break;
            }
            Thread.sleep(1000L);
            boolean isFistTime = true;
            block1: while (true) {
                useAnotherIdentifier.set(false);
                identifier = NodeDiscovery.proposeRandomUnusedIdentifier((DirectBitSet)knownAndProposedIdentifiers, isFistTime);
                ourProposedIdentifier.set(identifier);
                NodeDiscoveryBroadcaster.LOG.info("proposing to use identifier=" + identifier);
                isFistTime = false;
                DiscoveryNodeBytesMarshallable.ProposedNodes proposedNodes = new DiscoveryNodeBytesMarshallable.ProposedNodes(this.ourAddressAndPort, identifier);
                Thread.sleep(1000L);
                countDownLatch.set(new CountDownLatch(1));
                for (int i = 0; i < 20; ++i) {
                    this.discoveryNodeBytesMarshallable.sendBootStrap(proposedNodes);
                    if (countDownLatch.get().await(i * 20, TimeUnit.MILLISECONDS)) {
                        if (useAnotherIdentifier.get()) {
                            NodeDiscoveryBroadcaster.LOG.info("Another node is using identifier=" + identifier + ", " + "going to have to select another one, we will wait 500ms before continuing");
                            continue block1;
                        }
                        break block5;
                    }
                    NodeDiscoveryBroadcaster.LOG.debug("timed-out getting a response from the server so sending another boot-strap  message");
                }
                break;
            }
            NodeDiscoveryBroadcaster.LOG.info("looks like we are the only node in the grid, so going to use identifier=" + identifier);
        }
        RemoteNodeValidator remoteNodeValidator = new RemoteNodeValidator(){
            private final ConcurrentMap<Byte, SocketAddress> identifiers = new ConcurrentHashMap<Byte, SocketAddress>();

            @Override
            public boolean validate(byte remoteIdentifier, SocketAddress remoteAddress) {
                SocketAddress lastKnownAddress = this.identifiers.putIfAbsent(remoteIdentifier, remoteAddress);
                if (remoteAddress.equals(lastKnownAddress)) {
                    return true;
                }
                NodeDiscovery.this.knownNodes.identifiers().set((long)remoteIdentifier);
                return lastKnownAddress == null;
            }
        };
        HashSet knownHostPorts0 = new HashSet(knownHostPorts);
        knownHostPorts0.remove(this.ourAddressAndPort);
        this.knownNodes.add(this.ourAddressAndPort, identifier);
        NodeDiscoveryBroadcaster.LOG.info("Using Remote identifier=" + identifier);
        this.nodeDiscoveryEventListenerAtomicReference.set(null);
        TcpTransportAndNetworkConfig tcpConfig = TcpTransportAndNetworkConfig.of(8123, new InetSocketAddress("192.168.1.253", 8123));
        ReplicationHub replicationHub = ((ReplicationHub.Builder)((ReplicationHub.Builder)ReplicationHub.builder().tcpTransportAndNetwork(tcpConfig)).remoteNodeValidator(remoteNodeValidator)).createWithId(identifier);
        return new ReplicationHubFindByName(replicationHub);
    }

    private static Collection<InetSocketAddress> toInetSocketCollection(Set<AddressAndPort> source) throws UnknownHostException {
        HashSet<AddressAndPort> addressAndPorts = new HashSet<AddressAndPort>(source);
        if (addressAndPorts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(addressAndPorts.size());
        for (AddressAndPort addressAndPort : addressAndPorts) {
            addresses.add(new InetSocketAddress(InetAddress.getByAddress(addressAndPort.address()).getHostAddress(), (int)addressAndPort.port()));
        }
        return addresses;
    }

    private DirectBitSet orBitSets(@NotNull DirectBitSet source, @NotNull DirectBitSet destination) {
        int i = (int)source.nextSetBit(0L);
        while (i > 0) {
            try {
                destination.set((long)i, true);
            }
            catch (IndexOutOfBoundsException e) {
                NodeDiscoveryBroadcaster.LOG.error("", (Throwable)e);
            }
            i = (int)source.nextSetBit((long)(i + 1));
        }
        return destination;
    }

    static byte proposeRandomUnusedIdentifier(DirectBitSet knownIdentifiers, boolean isFirstTime) throws UnknownHostException {
        byte possible;
        if (isFirstTime) {
            byte[] address = InetAddress.getLocalHost().getAddress();
            int lastAddress = address[address.length - 1];
            if (lastAddress > 127) {
                lastAddress -= 127;
            }
            if (lastAddress > 127) {
                lastAddress -= 127;
            }
            possible = (byte)lastAddress;
        } else {
            possible = (byte)(Math.random() * 128.0);
        }
        int count = 0;
        while (!knownIdentifiers.setIfClear((long)possible)) {
            if (++count == 128) {
                throw new IllegalStateException("The grid is full, its not possible for any more nodes to going the grid.");
            }
            if (possible == 127) {
                possible = 0;
                continue;
            }
            possible = (byte)(possible + 1);
        }
        return possible;
    }

    static {
        InetAddress mask = null;
        try {
            mask = Inet4Address.getByName("224.0.8.0");
        }
        catch (Exception e) {
            mask = null;
        }
        IP_MULIT_CAST_GROUP = mask;
    }
}

