/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.replication;

import java.util.function.Consumer;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.ReplicatedHashSegmentContext;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.query.QueryAlloc;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class ReplicatedQueryAlloc
extends QueryAlloc {
    @StageRef
    ReplicatedChronicleMapHolder<?, ?, ?, ?, ?, ?, ?> mh;
    @StageRef
    SegmentStages s;
    final CleanupAction cleanupAction = new CleanupAction();

    public boolean forcedOldDeletedEntriesCleanup() {
        VanillaChronicleMap map = this.mh.m();
        try (HashSegmentContext sc = map.segmentContext(this.s.segmentIndex);){
            this.cleanupAction.removedCompletely = 0;
            ((ReplicatedHashSegmentContext)sc).forEachSegmentReplicableEntry(this.cleanupAction);
            boolean bl = this.cleanupAction.removedCompletely > 0;
            return bl;
        }
    }

    @Override
    public long alloc(int chunks) {
        long ret = this.s.allocReturnCode(chunks);
        if (ret >= 0L) {
            return ret;
        }
        int alreadyAttemptedTier = !this.forcedOldDeletedEntriesCleanup() ? this.s.segmentTier : -1;
        this.s.goToFirstTier();
        while (this.s.segmentTier == alreadyAttemptedTier || (ret = this.s.allocReturnCode(chunks)) < 0L) {
            this.s.nextTier();
        }
        return ret;
    }

    private class CleanupAction
    implements Consumer<ReplicableEntry> {
        int removedCompletely;

        private CleanupAction() {
        }

        @Override
        public void accept(ReplicableEntry e) {
            VanillaChronicleMap map = ReplicatedQueryAlloc.this.mh.m();
            if (e instanceof MapAbsentEntry) {
                long deleteTimeout = ((ReplicatedChronicleMap)map).timeProvider.currentTime() - e.originTimestamp();
                ((ReplicatedChronicleMap)map).timeProvider.systemTimeIntervalBetween(e.originTimestamp(), ((ReplicatedChronicleMap)map).timeProvider.currentTime(), ((ReplicatedChronicleMap)map).cleanupTimeoutUnit);
                if (deleteTimeout > ((ReplicatedChronicleMap)map).cleanupTimeout && !e.isChanged()) {
                    e.doRemoveCompletely();
                    ++this.removedCompletely;
                }
            }
        }
    }
}

