/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.SerializationBuilder;
import net.openhft.chronicle.map.AbstractChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.DefaultSpi;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.MapMethods;
import net.openhft.chronicle.map.MapQueryContext;
import net.openhft.chronicle.map.MapSegmentContext;
import net.openhft.chronicle.map.impl.CompiledMapIterationContext;
import net.openhft.chronicle.map.impl.CompiledMapQueryContext;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.NullReturnValue;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class VanillaChronicleMap<K, V, R>
extends VanillaChronicleHash<K, MapEntry<K, V>, MapSegmentContext<K, V, ?>, ExternalMapQueryContext<K, V, ?>>
implements AbstractChronicleMap<K, V> {
    Class<V> valueClass;
    public SizeMarshaller valueSizeMarshaller;
    public SizedReader<V> valueReader;
    public DataAccess<V> valueDataAccess;
    public boolean constantlySizedEntry;
    public int alignment;
    public int worstAlignment;
    public transient boolean couldNotDetermineAlignmentBeforeAllocation;
    transient boolean putReturnsNull;
    transient boolean removeReturnsNull;
    transient Set<Map.Entry<K, V>> entrySet;
    public transient ChronicleSet<K> chronicleSet;
    public transient MapEntryOperations<K, V, R> entryOperations;
    public transient MapMethods<K, V, R> methods;
    private transient boolean defaultEntryOperationsAndMethods;
    public transient DefaultValueProvider<K, V> defaultValueProvider;
    transient ThreadLocal<ChainingInterface> cxt;

    public VanillaChronicleMap(ChronicleMapBuilder<K, V> builder) throws IOException {
        super(builder);
        SerializationBuilder valueBuilder = builder.valueBuilder;
        this.valueClass = valueBuilder.tClass;
        this.valueSizeMarshaller = valueBuilder.sizeMarshaller();
        this.valueReader = valueBuilder.reader();
        this.valueDataAccess = valueBuilder.dataAccess();
        this.constantlySizedEntry = builder.constantlySizedEntries();
        this.alignment = builder.valueAlignment();
        this.worstAlignment = builder.worstAlignment();
        this.initTransientsFromBuilder(builder);
        this.initTransients();
    }

    @Override
    protected void readMarshallableFields(@NotNull WireIn wireIn) {
        super.readMarshallableFields(wireIn);
        this.valueClass = wireIn.read(() -> "valueClass").typeLiteral();
        this.valueSizeMarshaller = (SizeMarshaller)wireIn.read(() -> "valueSizeMarshaller").typedMarshallable();
        this.valueReader = (SizedReader)wireIn.read(() -> "valueReader").typedMarshallable();
        this.valueDataAccess = (DataAccess)wireIn.read(() -> "valueDataAccess").typedMarshallable();
        this.constantlySizedEntry = wireIn.read(() -> "constantlySizedEntry").bool();
        this.alignment = wireIn.read(() -> "alignment").int32();
        this.worstAlignment = wireIn.read(() -> "worstAlignment").int32();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        super.writeMarshallable(wireOut);
        wireOut.write(() -> "valueClass").typeLiteral(this.valueClass);
        wireOut.write(() -> "valueSizeMarshaller").typedMarshallable((WriteMarshallable)this.valueSizeMarshaller);
        wireOut.write(() -> "valueReader").typedMarshallable(this.valueReader);
        wireOut.write(() -> "valueDataAccess").typedMarshallable(this.valueDataAccess);
        wireOut.write(() -> "constantlySizedEntry").bool(Boolean.valueOf(this.constantlySizedEntry));
        wireOut.write(() -> "alignment").int32(this.alignment);
        wireOut.write(() -> "worstAlignment").int32(this.worstAlignment);
    }

    void initTransientsFromBuilder(ChronicleMapBuilder<K, V> builder) {
        this.putReturnsNull = builder.putReturnsNull();
        this.removeReturnsNull = builder.removeReturnsNull();
        this.entryOperations = builder.entryOperations;
        this.methods = builder.methods;
        this.defaultEntryOperationsAndMethods = this.entryOperations == DefaultSpi.mapEntryOperations() && this.methods == DefaultSpi.mapMethods();
        this.defaultValueProvider = builder.defaultValueProvider;
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.initOwnTransients();
    }

    public void recover() throws IOException {
        this.basicRecover();
        try (IterationContext<K, V, ?> iterationContext = this.iterationContext();){
            iterationContext.recoverSegments();
        }
    }

    private void initOwnTransients() {
        this.couldNotDetermineAlignmentBeforeAllocation = ChronicleMapBuilder.greatestCommonDivisor((int)this.chunkSize, this.alignment) != this.alignment;
        this.cxt = new ThreadLocal();
    }

    public final V checkValue(Object value) {
        if (!this.valueClass.isInstance(value)) {
            throw new ClassCastException("Value must be a " + this.valueClass.getName() + " but was a " + value.getClass());
        }
        return (V)value;
    }

    @Override
    public final long longSize() {
        long result = 0L;
        try (IterationContext<K, V, ?> c = this.iterationContext();){
            for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
                c.initSegmentIndex(segmentIndex);
                result += c.size();
            }
        }
        return result;
    }

    @Override
    public Class<K> keyClass() {
        return this.keyClass;
    }

    @Override
    public Class<V> valueClass() {
        return this.valueClass;
    }

    @Override
    @NotNull
    public final Closeable acquireContext(K key, V usingValue) {
        ExternalHashQueryContext q = this.queryContext((Object)key);
        try {
            q.writeLock().lock();
            VanillaChronicleMap.checkAcquiredUsing(this.acquireUsingBody((QueryContextInterface<K, V, R>)q, usingValue), usingValue);
            return q.acquireHandle();
        }
        catch (Throwable e) {
            try {
                q.close();
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    private static <V> void checkAcquiredUsing(V acquired, V using) {
        if (acquired != using) {
            throw new IllegalArgumentException("acquire*() MUST reuse the given value. Given value " + using + " cannot be reused to read " + acquired);
        }
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = this.newEntrySet());
    }

    @Override
    public int hashCode() {
        return this.mapHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.mapEquals(obj);
    }

    public String toString() {
        return this.mapToString();
    }

    @Override
    public void clear() {
        this.forEachEntry((? super E c) -> c.context().remove(c));
    }

    public final long readValueSize(Bytes entry) {
        long valueSize = this.valueSizeMarshaller.readSize(entry);
        this.alignReadPosition(entry);
        return valueSize;
    }

    public void alignReadPosition(Bytes entry) {
        long positionAddr = entry.address(entry.readPosition());
        long skip = VanillaChronicleMap.alignAddr(positionAddr, this.alignment) - positionAddr;
        if (skip > 0L) {
            entry.readSkip(skip);
        }
    }

    public static long alignAddr(long addr, long alignment) {
        return addr + alignment - 1L & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private ChainingInterface q() {
        CompiledMapQueryContext queryContext = this.cxt.get();
        if (queryContext == null) {
            queryContext = new CompiledMapQueryContext(this);
            this.addContext(queryContext);
            this.cxt.set(queryContext);
        }
        return queryContext;
    }

    public QueryContextInterface<K, V, R> mapContext() {
        return this.q().getContext(CompiledMapQueryContext.class, ci -> new CompiledMapQueryContext((ChainingInterface)ci, this));
    }

    private ChainingInterface i() {
        CompiledMapIterationContext iterContext = this.cxt.get();
        if (iterContext == null) {
            iterContext = new CompiledMapIterationContext(this);
            this.addContext(iterContext);
            this.cxt.set(iterContext);
        }
        return iterContext;
    }

    public IterationContext<K, V, ?> iterationContext() {
        return this.i().getContext(CompiledMapIterationContext.class, ci -> new CompiledMapIterationContext((ChainingInterface)ci, this));
    }

    @Override
    @NotNull
    public QueryContextInterface<K, V, R> queryContext(Object key) {
        this.checkKey(key);
        QueryContextInterface<Object, V, R> q = this.mapContext();
        q.initInputKey(q.inputKeyDataAccess().getData(key));
        return q;
    }

    @Override
    @NotNull
    public QueryContextInterface<K, V, R> queryContext(Data<K> key) {
        QueryContextInterface<K, V, R> q = this.mapContext();
        q.initInputKey(key);
        return q;
    }

    @Override
    @NotNull
    public ExternalMapQueryContext<K, V, ?> queryContext(BytesStore keyBytes, long offset, long size) {
        Objects.requireNonNull(keyBytes);
        QueryContextInterface<K, V, R> q = this.mapContext();
        q.initInputKey(q.getInputKeyBytesAsData(keyBytes, offset, size));
        return q;
    }

    @Override
    public MapSegmentContext<K, V, ?> segmentContext(int segmentIndex) {
        IterationContext<K, V, ?> c = this.iterationContext();
        c.initSegmentIndex(segmentIndex);
        return c;
    }

    @Override
    public V get(Object key) {
        return (V)(this.defaultEntryOperationsAndMethods ? this.optimizedGet(key, null) : this.defaultGet(key));
    }

    final V defaultGet(Object key) {
        try (ExternalHashQueryContext q = this.queryContext(key);){
            this.methods.get(q, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    /*
     * Loose catch block
     */
    private V optimizedGet(Object key, V using) {
        this.checkKey(key);
        CompiledMapQueryContext q = (CompiledMapQueryContext)this.mapContext();
        Data<Object> inputKey = q.inputKeyDataAccess().getData(key);
        try {
            V v;
            Throwable primaryExc = null;
            long inputKeySize = inputKey.size();
            long keyHash = inputKey.hash(LongHashFunction.xx_r39());
            HashSplitting hs = this.hashSplitting;
            int segmentIndex = hs.segmentIndex(keyHash);
            long segmentHeaderAddress = this.segmentHeaderAddress(segmentIndex);
            boolean needReadUnlock = false;
            try {
                CompactOffHeapLinearHashTable hl = this.hashLookup;
                long searchKey = hl.maskUnsetKey(hs.segmentHash(keyHash));
                long searchStartPos = hl.hlPos(searchKey);
                boolean needReadLock = true;
                int indexOfThisContext = q.indexInContextChain;
                int size = q.contextChain.size();
                for (int i = 0; i < size; ++i) {
                    LocksInterface root;
                    LocksInterface c;
                    if (i == indexOfThisContext || !(c = (LocksInterface)((Object)q.contextChain.get(i))).segmentHeaderInit() || c.segmentHeaderAddress() != segmentHeaderAddress || !c.locksInit() || (root = c.rootContextLockedOnThisSegment()).totalReadLockCount() <= 0 && root.totalUpdateLockCount() <= 0 && root.totalWriteLockCount() <= 0) continue;
                    needReadLock = false;
                    break;
                }
                if (needReadLock) {
                    BigSegmentHeader.INSTANCE.readLock(segmentHeaderAddress);
                    needReadUnlock = true;
                }
                v = this.tieredValue(q, segmentHeaderAddress, segmentIndex, searchKey, searchStartPos, inputKeySize, inputKey, using);
            }
            catch (Throwable t) {
                primaryExc = t;
                throw t;
            }
            finally {
                if (primaryExc != null) {
                    try {
                        this.getClose(q, segmentHeaderAddress, needReadUnlock);
                    }
                    catch (Throwable suppressedExc) {
                        primaryExc.addSuppressed(suppressedExc);
                    }
                } else {
                    this.getClose(q, segmentHeaderAddress, needReadUnlock);
                }
            }
            return v;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            q.doCloseInputKeyDataAccess();
        }
    }

    private void getClose(CompiledMapQueryContext<K, V, R> q, long segmentHeaderAddress, boolean needReadUnlock) {
        if (needReadUnlock) {
            BigSegmentHeader.INSTANCE.readUnlock(segmentHeaderAddress);
        }
        q.doCloseUsed();
    }

    private V tieredValue(CompiledMapQueryContext<K, V, R> q, long segmentHeaderAddress, int segmentIndex, long searchKey, long searchStartPos, long inputKeySize, Data<K> inputKey, V using) {
        int tier = 0;
        long tierBaseAddr = this.segmentBaseAddr(segmentIndex);
        V value;
        while ((value = this.searchValue(q, searchKey, searchStartPos, tierBaseAddr, inputKeySize, inputKey, using)) == null) {
            long nextTierIndex = tier == 0 ? BigSegmentHeader.INSTANCE.nextTierIndex(segmentHeaderAddress) : TierCountersArea.nextTierIndex(tierBaseAddr + this.tierHashLookupOuterSize);
            if (nextTierIndex == 0L) {
                return null;
            }
            ++tier;
            tierBaseAddr = this.tierIndexToBaseAddr(nextTierIndex);
        }
        return value;
    }

    private V searchValue(CompiledMapQueryContext<K, V, R> q, long searchKey, long searchStartPos, long tierBaseAddr, long inputKeySize, Data<K> inputKey, V using) {
        long entry;
        CompactOffHeapLinearHashTable hl = this.hashLookup;
        PointerBytesStore segmentBytesStore = q.segmentBS;
        segmentBytesStore.set(tierBaseAddr, this.tierSize);
        Bytes bs = q.segmentBytes;
        bs.clear();
        long freeListOffset = this.tierHashLookupOuterSize + 64L;
        long entrySpaceOffset = freeListOffset + this.tierFreeListOuterSize + (long)this.tierEntrySpaceInnerOffset;
        long hlPos = searchStartPos;
        while (!hl.empty(entry = hl.readEntryVolatile(tierBaseAddr, hlPos))) {
            if ((hlPos = hl.step(hlPos)) == searchStartPos) {
                throw new IllegalStateException("HashLookup overflow should never occur");
            }
            if (hl.key(entry) != searchKey) continue;
            long entryPos = hl.value(entry);
            long keySizeOffset = entrySpaceOffset + entryPos * this.chunkSize;
            bs.readLimit(bs.capacity());
            bs.readPosition(keySizeOffset);
            long keySize = this.keySizeMarshaller.readSize(bs);
            long keyOffset = bs.readPosition();
            if (inputKeySize != keySize || !inputKey.equivalent((RandomDataInput)segmentBytesStore, keyOffset)) continue;
            long valueSizeOffset = keyOffset + keySize;
            bs.readPosition(valueSizeOffset);
            long valueSize = this.readValueSize(bs);
            return q.valueReader.read(bs, valueSize, using);
        }
        return null;
    }

    @Override
    public V getUsing(K key, V usingValue) {
        return this.defaultEntryOperationsAndMethods ? this.optimizedGet(key, usingValue) : this.defaultGetUsing(key, usingValue);
    }

    final V defaultGetUsing(K key, V usingValue) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.usingReturnValue().initUsingReturnValue(usingValue);
            this.methods.get(q, q.usingReturnValue());
            Object v = q.usingReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V acquireUsing(K key, V usingValue) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            V v = this.acquireUsingBody((QueryContextInterface<K, V, R>)q, usingValue);
            return v;
        }
    }

    private V acquireUsingBody(QueryContextInterface<K, V, R> q, V usingValue) {
        q.usingReturnValue().initUsingReturnValue(usingValue);
        this.methods.acquireUsing(q, q.usingReturnValue());
        return q.usingReturnValue().returnValue();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.putIfAbsent(q, q.inputValueDataAccess().getData(value), q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (value == null) {
            return false;
        }
        V v = this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext(key);){
            boolean bl = this.methods.remove(q, q.inputValueDataAccess().getData(v));
            return bl;
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkValue(oldValue);
        this.checkValue(newValue);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            boolean bl = this.methods.replace(q, q.inputValueDataAccess().getData(oldValue), q.wrapValueAsData(newValue));
            return bl;
        }
    }

    @Override
    public V replace(K key, V value) {
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.replace(q, q.inputValueDataAccess().getData(value), q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try (ExternalHashQueryContext q = this.queryContext(key);){
            boolean bl = this.methods.containsKey((MapQueryContext<K, V, R>)((Object)q));
            return bl;
        }
    }

    @Override
    public V put(K key, V value) {
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            Data valueData = q.inputValueDataAccess().getData(value);
            InstanceReturnValue returnValue = this.putReturnsNull ? NullReturnValue.get() : q.defaultReturnValue();
            this.methods.put(q, valueData, returnValue);
            Object v = returnValue.returnValue();
            return v;
        }
    }

    @Override
    public V remove(Object key) {
        try (ExternalHashQueryContext q = this.queryContext(key);){
            InstanceReturnValue returnValue = this.removeReturnsNull ? NullReturnValue.get() : q.defaultReturnValue();
            this.methods.remove(q, returnValue);
            Object v = returnValue.returnValue();
            return v;
        }
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.merge((MapQueryContext<K, ? extends V, R>)((Object)q), q.inputValueDataAccess().getData(value), (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.compute((MapQueryContext<? super K, ? extends V, R>)((Object)q), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.computeIfAbsent((MapQueryContext<? super K, ? extends V, R>)((Object)q), mappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.computeIfPresent((MapQueryContext<? super K, ? extends V, R>)((Object)q), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    public void verifyTierCountersAreaData() {
        for (int i = 0; i < this.actualSegments; ++i) {
            try (HashSegmentContext c = this.segmentContext(i);){
                Method verifyTierCountersAreaData = c.getClass().getMethod("verifyTierCountersAreaData", new Class[0]);
                verifyTierCountersAreaData.invoke((Object)c, new Object[0]);
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

