/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.hash.replication.ReplicableEntry;

public final class DefaultEventualConsistencyStrategy {
    public static AcceptanceDecision decideOnRemoteModification(ReplicableEntry entry, RemoteOperationContext<?> context) {
        byte originIdentifier;
        long originTimestamp;
        long remoteTimestamp = context.remoteTimestamp();
        if (remoteTimestamp > (originTimestamp = entry.originTimestamp())) {
            return AcceptanceDecision.ACCEPT;
        }
        if (remoteTimestamp < originTimestamp) {
            return AcceptanceDecision.DISCARD;
        }
        byte remoteIdentifier = context.remoteIdentifier();
        if (remoteIdentifier < (originIdentifier = entry.originIdentifier())) {
            return AcceptanceDecision.ACCEPT;
        }
        if (remoteIdentifier > originIdentifier) {
            return AcceptanceDecision.DISCARD;
        }
        return originIdentifier == context.currentNodeIdentifier() ? AcceptanceDecision.DISCARD : AcceptanceDecision.ACCEPT;
    }

    private DefaultEventualConsistencyStrategy() {
    }

    public static enum AcceptanceDecision {
        ACCEPT,
        DISCARD;

    }
}

