/*
 *      Copyright (C) 2012, 2016  higherfrequencytrading.com
 *      Copyright (C) 2016 Roman Leventov
 *
 *      This program is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU Lesser General Public License as published by
 *      the Free Software Foundation, either version 3 of the License.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU Lesser General Public License for more details.
 *
 *      You should have received a copy of the GNU Lesser General Public License
 *      along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.openhft.chronicle.map.impl.stage.iter;

import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.replication.ReplicableEntryDelegating;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.impl.stage.entry.ReplicatedMapEntryStages;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public class  ReplicatedMapEntryDelegating<K, V>
        implements MapEntry<K, V>, ReplicableEntryDelegating {

    @StageRef ReplicatedMapSegmentIteration<K, V, ?> delegate;
    @StageRef ReplicatedMapEntryStages<K, V> e;

    @NotNull
    @Override
    public MapContext<K, V, ?> context() {
        return delegate.context();
    }

    @NotNull
    @Override
    public Data<K> key() {
        return delegate.key();
    }

    @NotNull
    @Override
    public Data<V> value() {
        return delegate.value();
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        delegate.doReplaceValue(newValue);
    }

    @Override
    public void doRemove() {
        delegate.doRemove();
    }

    @Override
    public ReplicableEntry d() {
        return e;
    }
}
