/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl;

import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;

public enum TierCountersArea {

    private static Memory memory = OS.memory();
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    public static final long NEXT_TIER_INDEX_OFFSET = 0L;
    public static final long PREV_TIER_INDEX_OFFSET = 8L;
    public static final long LOWEST_POSSIBLY_FREE_CHUNK_TIERED_OFFSET = 16L;
    public static final long SEGMENT_INDEX_OFFSET = 24L;
    public static final long TIER_OFFSET = 28L;
    public static final long ENTRIES_OFFSET = 32L;
    public static final long DELETED_OFFSET = 36L;

    public static long nextTierIndex(long address) {
        return memory.readLong(address + 0L);
    }

    public static void nextTierIndex(long address, long nextTierIndex) {
        memory.writeLong(address + 0L, nextTierIndex);
    }

    public static long lowestPossiblyFreeChunkTiered(long address) {
        return memory.readLong(address + 16L);
    }

    public static void lowestPossiblyFreeChunkTiered(long address, long lowestPossiblyFreeChunk) {
        memory.writeLong(address + 16L, lowestPossiblyFreeChunk);
    }

    public static long prevTierIndex(long address) {
        return memory.readLong(address + 8L);
    }

    public static void prevTierIndex(long address, long prevTierIndex) {
        memory.writeLong(address + 8L, prevTierIndex);
    }

    public static int segmentIndex(long address) {
        return memory.readInt(address + 24L);
    }

    public static void segmentIndex(long address, int segmentIndex) {
        memory.writeInt(address + 24L, segmentIndex);
    }

    public static int tier(long address) {
        return memory.readInt(address + 28L);
    }

    public static void tier(long address, int tier) {
        memory.writeInt(address + 28L, tier);
    }

    public static long entries(long address) {
        return (long)memory.readInt(address + 32L) & 0xFFFFFFFFL;
    }

    public static void entries(long address, long entries) {
        if (entries >= 0x100000000L) {
            throw new IllegalStateException("tier entries overflow: up to 4294967295 supported, " + entries + " given");
        }
        memory.writeInt(address + 32L, (int)entries);
    }

    public static long deleted(long address) {
        return (long)memory.readInt(address + 36L) & 0xFFFFFFFFL;
    }

    public static void deleted(long address, long deleted) {
        if (deleted >= 0x100000000L) {
            throw new IllegalStateException("tier deleted entries count overflow: up to 4294967295 supported, " + deleted + " given");
        }
        memory.writeInt(address + 36L, (int)deleted);
    }
}

