/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.query;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupSearch;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class KeySearch<K> {
    @StageRef
    public SegmentStages s;
    @StageRef
    public HashLookupSearch hashLookupSearch;
    @StageRef
    public HashEntryStages<K> entry;
    public Data<K> inputKey = null;
    @Stage(value="KeySearch")
    protected SearchState searchState = null;
    @StageRef
    VanillaChronicleMapHolder<?, ?, ?> mh;

    public abstract boolean inputKeyInit();

    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
    }

    public abstract boolean keySearchInit();

    @Stage(value="KeySearch")
    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.hashLookupSearch.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            long keySizeOffset = this.s.entrySpaceOffset + pos * this.mh.m().chunkSize;
            Bytes segmentBytes = this.s.segmentBytesForRead();
            segmentBytes.readPosition(keySizeOffset);
            long keySize = this.mh.h().keySizeMarshaller.readSize(segmentBytes);
            long keyOffset = segmentBytes.readPosition();
            if (!this.keyEquals(keySize, keyOffset)) continue;
            this.hashLookupSearch.found();
            this.entry.readFoundEntry(pos, keySizeOffset, keySize, keyOffset);
            this.searchState = SearchState.PRESENT;
            return;
        }
        this.searchState = SearchState.ABSENT;
    }

    boolean keyEquals(long keySize, long keyOffset) {
        return this.inputKey.size() == keySize && this.inputKey.equivalent((RandomDataInput)this.s.segmentBS, keyOffset);
    }

    public boolean searchStatePresent() {
        return this.searchState == SearchState.PRESENT;
    }

    public boolean searchStateAbsent() {
        return this.searchState == SearchState.ABSENT;
    }

    public static enum SearchState {
        PRESENT,
        ABSENT;

    }
}

