/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.MapSegmentContext;

public final class MapDiagnostics {
    private MapDiagnostics() {
    }

    public static void main(String[] args) throws IOException {
        String mapFile = args[0];
        try (ChronicleHash map = ChronicleMap.of(Object.class, Object.class).createPersistedTo(new File(mapFile));){
            MapDiagnostics.printMapStats(map);
        }
    }

    public static <K, V> void printMapStats(ChronicleMap<K, V> map) {
        for (int i = 0; i < map.segments(); ++i) {
            try (MapSegmentContext c = (MapSegmentContext)map.segmentContext(i);){
                System.out.printf("segment %d contains %d entries\n", i, c.size());
                c.forEachSegmentEntry(e -> System.out.printf("%s, %d bytes -> %s, %d bytes\n", e.key(), e.key().size(), e.value(), e.value().size()));
                continue;
            }
        }
    }
}

