/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import net.openhft.chronicle.hash.impl.util.Objects;

public final class Throwables {
    private Throwables() {
    }

    public static RuntimeException propagate(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static <T extends Throwable> T propagateNotWrapping(Throwable t, Class<T> notWrappingThrowableType) throws T {
        Objects.requireNonNull(t);
        Objects.requireNonNull(notWrappingThrowableType);
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (notWrappingThrowableType.isInstance(t)) {
            throw (Throwable)notWrappingThrowableType.cast(t);
        }
        throw new RuntimeException(t);
    }

    public static Throwable returnOrSuppress(Throwable thrown, Throwable t) {
        if (thrown == null) {
            return t;
        }
        if (t != null) {
            thrown.addSuppressed(t);
        }
        return thrown;
    }
}

