/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.channel;

import java.io.IOException;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.channel.MapService;
import net.openhft.chronicle.map.channel.internal.MapChannel;
import net.openhft.chronicle.wire.channel.AbstractHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;

public class MapHandler<VALUE, REPLY>
extends AbstractHandler<MapHandler<VALUE, REPLY>> {
    protected MapService<VALUE, REPLY> mapService;
    private String mapName;

    protected MapHandler(String mapName) {
        this.mapName = mapName;
    }

    public static <V, O> MapHandler<V, O> createMapHandler(String mapName, MapService<V, O> mapService) {
        MapHandler mh = new MapHandler(mapName);
        mh.mapService = mapService;
        return mh;
    }

    public void run(ChronicleContext context, ChronicleChannel channel) {
        try (ChronicleMap<Bytes<?>, VALUE> map = MapChannel.createMap(this.mapName, this.mapService, context);){
            Object REPLY = channel.methodWriter(this.mapService().replyClass(), new Class[0]);
            this.mapService.map(map);
            this.mapService.reply(REPLY);
            try (AffinityLock lock = context.affinityLock();){
                assert (lock != null);
                channel.eventHandlerAsRunnable(this.mapService).run();
            }
        }
        catch (IOException ioe) {
            throw Jvm.rethrow((Throwable)ioe);
        }
    }

    public ChronicleChannel asInternalChannel(ChronicleContext context, ChronicleChannelCfg channelCfg) {
        return new MapChannel<VALUE, REPLY>(this.mapName, this.mapService, context, channelCfg);
    }

    protected MapService<VALUE, REPLY> mapService() {
        return this.mapService;
    }
}

