/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.locks.InterProcessDeadLockException;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public class WriteLock
implements InterProcessLock {
    @StageRef
    VanillaChronicleHashHolder<?> hh;
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;
    @StageRef
    SegmentStages s;
    @StageRef
    HashEntryStages<?> entry;

    @Override
    public boolean isHeldByCurrentThread() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        return this.s.localLockState.write;
    }

    @Override
    public void lock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        this.s.segmentHeader.upgradeUpdateToWriteLock(this.s.segmentHeaderAddress);
                    } else {
                        if (!this.s.readZero()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        try {
                            this.s.segmentHeader.writeLock(this.s.segmentHeaderAddress);
                        }
                        catch (InterProcessDeadLockException e) {
                            throw this.s.debugContextsAndLocks(e);
                        }
                    }
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    try {
                        this.s.segmentHeader.upgradeUpdateToWriteLock(this.s.segmentHeaderAddress);
                    }
                    catch (InterProcessDeadLockException e) {
                        throw this.s.debugContextsAndLocks(e);
                    }
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                break;
            }
        }
    }

    @NotNull
    private IllegalMonitorStateException forbiddenUpgrade() {
        return new IllegalMonitorStateException(this.hh.h().toIdentityString() + ": Cannot upgrade from read to write lock");
    }

    @NotNull
    private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
        return new IllegalStateException(this.hh.h().toIdentityString() + ": Cannot acquire write lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        this.s.segmentHeader.upgradeUpdateToWriteLockInterruptibly(this.s.segmentHeaderAddress);
                    } else {
                        if (!this.s.readZero()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        try {
                            this.s.segmentHeader.writeLockInterruptibly(this.s.segmentHeaderAddress);
                        }
                        catch (InterProcessDeadLockException e) {
                            throw this.s.debugContextsAndLocks(e);
                        }
                    }
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    try {
                        this.s.segmentHeader.upgradeUpdateToWriteLockInterruptibly(this.s.segmentHeaderAddress);
                    }
                    catch (InterProcessDeadLockException e) {
                        throw this.s.debugContextsAndLocks(e);
                    }
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                break;
            }
        }
    }

    @Override
    public boolean tryLock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress)) {
                            this.s.incrementWrite();
                            this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    if (!this.s.readZero()) {
                        throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryWriteLock(this.s.segmentHeaderAddress)) {
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress)) {
                        this.s.decrementUpdate();
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new IllegalStateException(this.hh.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)this.s.localLockState));
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        switch (this.s.localLockState) {
            case UNLOCKED: {
                this.s.checkIterationContextNotLockedInThisThread();
                if (this.s.writeZero()) {
                    if (!this.s.updateZero()) {
                        if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress, time, unit)) {
                            this.s.incrementWrite();
                            this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    if (!this.s.readZero()) {
                        throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                    }
                    if (this.s.segmentHeader.tryWriteLock(this.s.segmentHeaderAddress, time, unit)) {
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case READ_LOCKED: {
                throw this.forbiddenUpgrade();
            }
            case UPDATE_LOCKED: {
                if (this.s.writeZero()) {
                    assert (!this.s.updateZero());
                    if (this.s.segmentHeader.tryUpgradeUpdateToWriteLock(this.s.segmentHeaderAddress, time, unit)) {
                        this.s.decrementUpdate();
                        this.s.incrementWrite();
                        this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                    return false;
                }
                this.s.decrementUpdate();
                this.s.incrementWrite();
                this.s.setLocalLockState(LocalLockState.WRITE_LOCKED);
                return true;
            }
            case WRITE_LOCKED: {
                return true;
            }
        }
        throw new IllegalStateException(this.hh.h().toIdentityString() + ": unexpected localLockState=" + (Object)((Object)this.s.localLockState));
    }

    @Override
    public void unlock() {
        this.checkOnEachPublicOperation.checkOnEachLockOperation();
        switch (this.s.localLockState) {
            case UNLOCKED: 
            case READ_LOCKED: 
            case UPDATE_LOCKED: {
                return;
            }
            case WRITE_LOCKED: {
                this.entry.closeDelayedUpdateChecksum();
                if (this.s.decrementWrite() == 0) {
                    this.s.segmentHeader.downgradeWriteToUpdateLock(this.s.segmentHeaderAddress);
                }
                this.s.incrementUpdate();
                this.s.setLocalLockState(LocalLockState.UPDATE_LOCKED);
            }
        }
    }

    @Override
    public boolean isHeld() {
        return this.s.localLockState != null && this.s.localLockState != LocalLockState.UNLOCKED;
    }
}

