package net.openhft.chronicle.map.impl;

import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import java.util.ArrayList;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.ChronicleHash;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import java.util.ConcurrentModificationException;
import java.util.function.Consumer;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import java.util.function.Function;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import java.util.List;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapSegmentContext;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import org.jetbrains.annotations.NotNull;
import java.util.Objects;
import net.openhft.chronicle.bytes.PointerBytesStore;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.set.SetContext;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.impl.stage.hash.ThreadLocalState;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.map.VanillaChronicleMap;

public class CompiledMapIterationContext<K, V, R> extends ChainingInterface implements AutoCloseable , ChecksumEntry , HashEntry<K> , HashSegmentContext<K, MapEntry<K, V>> , SegmentLock , Alloc , KeyHashCode , LocksInterface , MapContext<K, V, R> , MapEntry<K, V> , IterationContext<K, V, R> , VanillaChronicleMapHolder<K, V, R> , SetContext<K, R> {
    public boolean readZeroGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return readZero();
    }

    public boolean reallocGuarded(long fromPos, int oldChunks, int newChunks) {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return realloc(fromPos, oldChunks, newChunks);
    }

    public boolean updateZeroGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return decrementWrite();
    }

    public String debugContextsAndLocksGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return debugContextsAndLocks();
    }

    public long allocReturnCodeGuarded(int chunks) {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return allocReturnCode(chunks);
    }

    public Bytes segmentBytesForReadGuarded() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return segmentBytesForRead();
    }

    public Bytes segmentBytesForWriteGuarded() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return segmentBytesForWrite();
    }

    public void close() {
        this.closeSegment();
        this.closeLocks();
        this.closePos();
        this.wrappedValueInstanceValueHolder.closeNext();
        this.closeEntrySizeInChunks();
        this.closeInputKey();
        this.closeEntryRemovedOnThisIteration();
        this.closeKeySearch();
        this.closeEntryOffset();
        this.closeDelayedUpdateChecksum();
        this.closeSearchKey();
        this.entryKey.closeCachedEntryKey();
        this.closeKeyHash();
        this.closeSegmentHeader();
        this.wrappedValueInstanceValueHolder.closeWrappedData();
        this.closeUsed();
        this.entryValue.closeCachedEntryValue();
        this.closeValueSize();
        this.closeSegmentTier();
        this.closeSegmentIndex();
        this.closeHashLookupEntry();
        this.wrappedValueInstanceValueHolder.closeValue();
        this.closeKeySize();
        this.closeHashLookupPos();
        this.closeKeyOffset();
        this.closeValueSizeOffset();
        this.closeAllocatedChunks();
        this.closeHashLookupSearchFoundDependants();
        this.closeHashLookupSearchHlDependants();
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
        this.closeMapEntryStagesKeyEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeIterationSegmentStagesRegisterIterationContextLockedInThisThreadDependants();
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeVanillaChronicleMapHolderImplMDependants();
        this.closeHashLookupSearchAddrDependants();
        this.closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeMapEntryStagesReadExistingEntryDependants();
        this.closeIterationKeyHashCodeKeyHashCodeDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.closeMapEntryStagesEntryEndDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.closeHashLookupSearchNextPosDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeMapEntryStagesEntrySizeDependants();
        this.closeIterationSegmentStagesDeregisterIterationContextLockedInThisThreadDependants();
    }

    public void freeExtraGuarded(long pos, int oldChunks, int newChunks) {
        if (!(this.segmentInit()))
            this.initSegment();
        
        freeExtra(pos, oldChunks, newChunks);
    }

    public void freeGuarded(long fromPos, int chunks) {
        if (!(this.segmentInit()))
            this.initSegment();
        
        free(fromPos, chunks);
    }

    public void incrementModCountGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!(this.locksInit()))
            this.initLocks();
        
        readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!(this.hashLookupPosInit()))
            this.initHashLookupPos();
        
        setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!(this.locksInit()))
            this.initLocks();
        
        setLocalLockState(newState);
    }

    void keyFound() {
        searchState = CompiledMapIterationContext.SearchState.PRESENT;
    }

    public CompiledMapIterationContext(ChainingInterface c ,VanillaChronicleMap<K, V, R> m) {
        contextChain = c.getContextChain();
        indexInContextChain = contextChain.size();
        contextChain.add(this);
        this.rootContextInThisThread = c;
        this.m = m;
        this.entryValue = new EntryValueBytesData();
        this.entryKey = new EntryKeyBytesData();
        this.valueReader = net.openhft.chronicle.hash.serialization.StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.innerReadLock = new ReadLock();
        this.keyReader = net.openhft.chronicle.hash.serialization.StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.owner = Thread.currentThread();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueInstanceValueHolder = new WrappedValueInstanceDataHolder();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes(segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet(new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)) , Access.nativeAccess() , null , 0);
    }

    public CompiledMapIterationContext(VanillaChronicleMap<K, V, R> m) {
        contextChain = new ArrayList<>();
        contextChain.add(this);
        indexInContextChain = 0;
        rootContextInThisThread = this;
        this.m = m;
        this.entryValue = new EntryValueBytesData();
        this.entryKey = new EntryKeyBytesData();
        this.valueReader = net.openhft.chronicle.hash.serialization.StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.innerReadLock = new ReadLock();
        this.keyReader = net.openhft.chronicle.hash.serialization.StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.owner = Thread.currentThread();
        this.innerWriteLock = new WriteLock();
        this.wrappedValueInstanceValueHolder = new WrappedValueInstanceDataHolder();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes(segmentBS);
        this.hashEntryChecksumStrategy = new HashEntryChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashEntryChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerUpdateLock = new UpdateLock();
        this.freeList = new ReusableBitSet(new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegmentTier, MemoryUnit.BITS)) , Access.nativeAccess() , null , 0);
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = this.contextAtIndexInChain(index);
        if (((c.segmentHeaderInit()) && ((c.segmentHeaderAddress()) == (segmentHeaderAddress()))) && (c.locksInit())) {
            LocksInterface root = c.rootContextLockedOnThisSegment();
            this.rootContextLockedOnThisSegment = root;
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            linkToSegmentContextsChain();
            return true;
        } else {
            return false;
        }
    }

    public class EntryKeyBytesData extends AbstractData<K> {
        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keyOffset();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.segmentBS();
        }

        private K innerGetUsing(K usingKey) {
            Bytes bytes = CompiledMapIterationContext.this.segmentBytesForReadGuarded();
            bytes.readPosition(CompiledMapIterationContext.this.keyOffset());
            return CompiledMapIterationContext.this.keyReader.read(bytes, size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        private K cachedEntryKey;

        private boolean cachedEntryKeyRead = false;

        public boolean cachedEntryKeyInit() {
            return (this.cachedEntryKeyRead) != false;
        }

        private void initCachedEntryKey() {
            cachedEntryKey = innerGetUsing(cachedEntryKey);
            cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!(this.cachedEntryKeyInit()))
                this.initCachedEntryKey();
            
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!(this.cachedEntryKeyInit()))
                return ;
            
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return cachedEntryKey();
        }

        @Override
        public K getUsing(K using) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return innerGetUsing(using);
        }
    }

    public class EntryValueBytesData extends AbstractData<V> {
        @Override
        public long offset() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            Bytes segmentBytes = CompiledMapIterationContext.this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(CompiledMapIterationContext.this.valueOffset());
            return CompiledMapIterationContext.this.valueReader.read(segmentBytes, size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V using) {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return innerGetUsing(using);
        }

        private V cachedEntryValue = (CompiledMapIterationContext.this.m().valueClass()) == (CharSequence.class) ? ((V)(new StringBuilder())) : null;

        private boolean cachedEntryValueRead = false;

        public boolean cachedEntryValueInit() {
            return cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            cachedEntryValue = innerGetUsing(cachedEntryValue);
            cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!(this.cachedEntryValueInit()))
                this.initCachedEntryValue();
            
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!(this.cachedEntryValueInit()))
                return ;
            
            cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return cachedEntryValue();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapIterationContext.this.checkOnEachPublicOperation();
            return CompiledMapIterationContext.this.segmentBS();
        }
    }

    public class HashEntryChecksumStrategy implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return ChecksumStrategy.CHECKSUM_STORED_BYTES;
        }

        private int computeChecksum() {
            long keyHashCode = CompiledMapIterationContext.this.keyHashCode();
            long keyEnd = CompiledMapIterationContext.this.keyEnd();
            long len = (CompiledMapIterationContext.this.entryEnd()) - keyEnd;
            long checksum;
            if (len > 0) {
                long addr = (CompiledMapIterationContext.this.tierBaseAddr()) + keyEnd;
                long payloadChecksum = LongHashFunction.xx_r39().hashMemory(addr, len);
                checksum = net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing.hash8To16Bytes(CompiledMapIterationContext.this.keySize(), keyHashCode, payloadChecksum);
            } else {
                checksum = net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing.hash8To16Bytes(CompiledMapIterationContext.this.keySize(), keyHashCode, keyHashCode);
            }
            return ((int)((checksum >>> 32) ^ checksum));
        }

        public void closeHashEntryChecksumStrategyComputeChecksumDependants() {
            this.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        }

        @Override
        public void computeAndStoreChecksum() {
            int checksum = computeChecksum();
            CompiledMapIterationContext.this.segmentBS().writeInt(CompiledMapIterationContext.this.entryEnd(), checksum);
        }

        public void closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants() {
            CompiledMapIterationContext.this.closeDelayedUpdateChecksum();
        }

        @Override
        public boolean innerCheckSum() {
            int oldChecksum = CompiledMapIterationContext.this.segmentBS().readInt(CompiledMapIterationContext.this.entryEnd());
            int checksum = computeChecksum();
            return oldChecksum == checksum;
        }
    }

    public class ReadLock implements InterProcessLock {
        @Override
        public void lockInterruptibly() throws InterruptedException {
            if ((CompiledMapIterationContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if (((CompiledMapIterationContext.this.readZeroGuarded()) && (CompiledMapIterationContext.this.updateZeroGuarded())) && (CompiledMapIterationContext.this.writeZeroGuarded()))
                    CompiledMapIterationContext.this.segmentHeader().readLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                
                CompiledMapIterationContext.this.incrementReadGuarded();
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            } 
        }

        @Override
        public void lock() {
            if ((CompiledMapIterationContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if (((CompiledMapIterationContext.this.readZeroGuarded()) && (CompiledMapIterationContext.this.updateZeroGuarded())) && (CompiledMapIterationContext.this.writeZeroGuarded()))
                    CompiledMapIterationContext.this.segmentHeader().readLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                
                CompiledMapIterationContext.this.incrementReadGuarded();
                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            } 
        }

        public void closeReadLockLockDependants() {
            CompiledMapIterationContext.this.closeHashLookupPos();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().read;
        }

        @Override
        public void unlock() {
            CompiledMapIterationContext.this.closeHashLookupPos();
            CompiledMapIterationContext.this.closePos();
            CompiledMapIterationContext.this.closeKeyOffset();
            CompiledMapIterationContext.this.readUnlockAndDecrementCountGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
        }

        @Override
        public boolean tryLock(long time, @NotNull
        TimeUnit unit) throws InterruptedException {
            if ((CompiledMapIterationContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if ((((!(CompiledMapIterationContext.this.readZeroGuarded())) || (!(CompiledMapIterationContext.this.updateZeroGuarded()))) || (!(CompiledMapIterationContext.this.writeZeroGuarded()))) || (CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit))) {
                    CompiledMapIterationContext.this.incrementReadGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }

        @Override
        public boolean tryLock() {
            if ((CompiledMapIterationContext.this.localLockState()) == (LocalLockState.UNLOCKED)) {
                if ((((!(CompiledMapIterationContext.this.readZeroGuarded())) || (!(CompiledMapIterationContext.this.updateZeroGuarded()))) || (!(CompiledMapIterationContext.this.writeZeroGuarded()))) || (CompiledMapIterationContext.this.segmentHeader().tryReadLock(CompiledMapIterationContext.this.segmentHeaderAddress()))) {
                    CompiledMapIterationContext.this.incrementReadGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        }
    }

    public class UpdateLock implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException(("Cannot acquire update lock, because outer context " + ("holds read lock. In this case you should acquire update lock in the outer " + "context up front")));
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledMapIterationContext.this.updateZeroGuarded()) && (CompiledMapIterationContext.this.writeZeroGuarded())) {
                        if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        CompiledMapIterationContext.this.segmentHeader().updateLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    } 
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().update;
        }

        @Override
        public void unlock() {
            CompiledMapIterationContext.this.closeDelayedUpdateChecksum();
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                case READ_LOCKED :
                    return ;
                case UPDATE_LOCKED :
                    int newTotalUpdateLockCount = CompiledMapIterationContext.this.decrementUpdateGuarded();
                    if (newTotalUpdateLockCount == 0) {
                        if (CompiledMapIterationContext.this.writeZeroGuarded())
                            CompiledMapIterationContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        
                    } else {
                        assert newTotalUpdateLockCount > 0 : "update underflow";
                    }
                    break;
                case WRITE_LOCKED :
                    int newTotalWriteLockCount = CompiledMapIterationContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        if (!(CompiledMapIterationContext.this.updateZeroGuarded())) {
                            CompiledMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            CompiledMapIterationContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                    } else {
                        assert newTotalWriteLockCount > 0 : "write underflow";
                    }
            }
            CompiledMapIterationContext.this.incrementReadGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledMapIterationContext.this.updateZeroGuarded()) && (CompiledMapIterationContext.this.writeZeroGuarded())) {
                        if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        try {
                            CompiledMapIterationContext.this.segmentHeader().updateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } catch (RuntimeException e) {
                            CompiledMapIterationContext.this.LOG.error(CompiledMapIterationContext.this.debugContextsAndLocksGuarded());
                            throw e;
                        }
                    } 
                    CompiledMapIterationContext.this.incrementUpdateGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
            }
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledMapIterationContext.this.updateZeroGuarded()) && (CompiledMapIterationContext.this.writeZeroGuarded())) {
                        if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.incrementUpdateGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledMapIterationContext.this.incrementUpdateGuarded();
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull
        TimeUnit unit) throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if ((CompiledMapIterationContext.this.updateZeroGuarded()) && (CompiledMapIterationContext.this.writeZeroGuarded())) {
                        if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                            throw forbiddenUpdateLockWhenOuterContextReadLocked();
                        
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.incrementUpdateGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledMapIterationContext.this.incrementUpdateGuarded();
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }
    }

    public class WrappedValueInstanceDataHolder {
        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolderGuarded() {
            assert this.nextInit() : "Next should be init";
            return getUnusedWrappedValueHolder();
        }

        public WrappedValueInstanceDataHolder() {
            this.wrappedValueDataAccess = CompiledMapIterationContext.this.m().valueDataAccess.copy();
        }

        private final DataAccess<V> wrappedValueDataAccess;

        public DataAccess<V> wrappedValueDataAccess() {
            return this.wrappedValueDataAccess;
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolder() {
            if (!(valueInit()))
                return this;
            
            if ((next) == null)
                next = new WrappedValueInstanceDataHolder();
            
            return next.getUnusedWrappedValueHolder();
        }

        private WrappedValueInstanceDataHolder next;

        boolean nextInit() {
            return true;
        }

        public WrappedValueInstanceDataHolder next() {
            assert this.nextInit() : "Next should be init";
            return this.next;
        }

        void closeNext() {
            if (!(this.nextInit()))
                return ;
            
            this.closeNextDependants();
        }

        public void closeNextDependants() {
            this.closeValue();
        }

        private V value;

        public boolean valueInit() {
            return (value) != null;
        }

        public void initValue(V value) {
            CompiledMapIterationContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert this.valueInit() : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!(this.valueInit()))
                return ;
            
            this.closeValueDependants();
            value = null;
            if ((next()) != null)
                next().closeValue();
            
        }

        public void closeValueDependants() {
            this.closeWrappedData();
        }

        public Data<V> wrappedData = null;

        public boolean wrappedDataInit() {
            return (this.wrappedData) != null;
        }

        private void initWrappedData() {
            wrappedData = wrappedValueDataAccess.getData(value());
        }

        public Data<V> wrappedData() {
            if (!(this.wrappedDataInit()))
                this.initWrappedData();
            
            return this.wrappedData;
        }

        private void closeWrappedData() {
            if (!(this.wrappedDataInit()))
                return ;
            
            wrappedData = null;
            wrappedValueDataAccess.uninit();
        }
    }

    public class WriteLock implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException(("Cannot acquire write lock, because outer context " + ("holds read lock. In this case you should acquire update lock in the outer " + "context up front")));
        }

        @Override
        public boolean tryLock(long time, @NotNull
        TimeUnit unit) throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!(CompiledMapIterationContext.this.updateZeroGuarded())) {
                            if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        } else {
                            if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        }
                    } else {
                        CompiledMapIterationContext.this.incrementWriteGuarded();
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert !(CompiledMapIterationContext.this.updateZeroGuarded());
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapIterationContext.this.decrementUpdateGuarded();
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledMapIterationContext.this.decrementUpdateGuarded();
                        CompiledMapIterationContext.this.incrementWriteGuarded();
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!(CompiledMapIterationContext.this.updateZeroGuarded())) {
                            if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        } else {
                            if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            if (CompiledMapIterationContext.this.segmentHeader().tryWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                                CompiledMapIterationContext.this.incrementWriteGuarded();
                                CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            } else {
                                return false;
                            }
                        }
                    } else {
                        CompiledMapIterationContext.this.incrementWriteGuarded();
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert !(CompiledMapIterationContext.this.updateZeroGuarded());
                        if (CompiledMapIterationContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress())) {
                            CompiledMapIterationContext.this.decrementUpdateGuarded();
                            CompiledMapIterationContext.this.incrementWriteGuarded();
                            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        } else {
                            return false;
                        }
                    } else {
                        CompiledMapIterationContext.this.decrementUpdateGuarded();
                        CompiledMapIterationContext.this.incrementWriteGuarded();
                        CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                        return true;
                    }
                case WRITE_LOCKED :
                    return true;
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!(CompiledMapIterationContext.this.updateZeroGuarded())) {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            CompiledMapIterationContext.this.segmentHeader().writeLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                    } 
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert !(CompiledMapIterationContext.this.updateZeroGuarded());
                        CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapIterationContext.this.segmentHeaderAddress());
                    } 
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                case WRITE_LOCKED :
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                case READ_LOCKED :
                case UPDATE_LOCKED :
                    return ;
                case WRITE_LOCKED :
                    int newTotalWriteLockCount = CompiledMapIterationContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        CompiledMapIterationContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    } else {
                        assert newTotalWriteLockCount > 0 : "write underflow";
                    }
            }
            CompiledMapIterationContext.this.incrementUpdateGuarded();
            CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledMapIterationContext.this.localLockState()) {
                case UNLOCKED :
                    CompiledMapIterationContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        if (!(CompiledMapIterationContext.this.updateZeroGuarded())) {
                            CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        } else {
                            if (!(CompiledMapIterationContext.this.readZeroGuarded()))
                                throw forbiddenWriteLockWhenOuterContextReadLocked();
                            
                            CompiledMapIterationContext.this.segmentHeader().writeLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                        }
                    } 
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return ;
                case READ_LOCKED :
                    throw forbiddenUpgrade();
                case UPDATE_LOCKED :
                    if (CompiledMapIterationContext.this.writeZeroGuarded()) {
                        assert !(CompiledMapIterationContext.this.updateZeroGuarded());
                        CompiledMapIterationContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapIterationContext.this.segmentHeaderAddress());
                    } 
                    CompiledMapIterationContext.this.decrementUpdateGuarded();
                    CompiledMapIterationContext.this.incrementWriteGuarded();
                    CompiledMapIterationContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                case WRITE_LOCKED :
            }
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapIterationContext.this.localLockState().write;
        }
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        return totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        return totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        return totalWriteLockCount += change;
    }

    public int decrementRead() {
        return rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    public enum SearchState {
PRESENT, DELETED, ABSENT;    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash<?, ?, ?, ?> h = this.h();
        if (chunks > (h.maxChunksPerEntry)) {
            throw new IllegalArgumentException((((("Entry is too large: requires " + chunks) + " chucks, ") + (h.maxChunksPerEntry)) + " is maximum."));
        } 
        long lowestPossiblyFreeChunk = lowestPossiblyFreeChunk();
        if ((lowestPossiblyFreeChunk + chunks) > (h.actualChunksPerSegmentTier))
            return -1;
        
        if ((tierEntries()) >= (h.maxEntriesPerHashLookup))
            return -1;
        
        assert lowestPossiblyFreeChunk < (h.actualChunksPerSegmentTier);
        long ret = freeList.setNextNContinuousClearBits(lowestPossiblyFreeChunk, chunks);
        if ((ret == (BitSetFrame.NOT_FOUND)) || ((ret + chunks) > (h.actualChunksPerSegmentTier))) {
            if ((ret + chunks) > (h.actualChunksPerSegmentTier)) {
                assert ret != (BitSetFrame.NOT_FOUND);
                freeList.clearRange(ret, (ret + chunks));
            } 
            return -1;
        } else {
            tierEntries(((tierEntries()) + 1));
            if ((chunks == 1) || (freeList.isSet(lowestPossiblyFreeChunk))) {
                lowestPossiblyFreeChunk((ret + chunks));
            } 
            return ret;
        }
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
        if (!(this.h().isOpen()))
            throw new IllegalStateException("Access to Chronicle Hash after close()");
        
    }

    private void _SegmentStages_checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        if ((innermostContextOnThisSegment.getClass()) == (getClass())) {
            Data key = ((CompiledMapIterationContext)(innermostContextOnThisSegment)).inputKey();
            if (Objects.equals(key, ((CompiledMapIterationContext)((Object)(this))).inputKey())) {
                throw new IllegalStateException((("Nested same-thread contexts cannot access " + "the same key ") + key));
            } 
        } 
    }

    private void _SegmentStages_nextTier() {
        VanillaChronicleHash<?, ?, ?, ?> h = this.h();
        long nextTierIndex = nextTierIndex();
        if (nextTierIndex == 0) {
            nextTierIndex = h.allocateTier(segmentIndex(), ((tier()) + 1));
            nextTierIndex(nextTierIndex);
            long currentTierIndex = tierIndex();
            initSegmentTier(((tier()) + 1), nextTierIndex);
            prevTierIndex(currentTierIndex);
        } else {
            initSegmentTier(((tier()) + 1), nextTierIndex);
        }
    }

    public void free(long fromPos, int chunks) {
        tierEntries(((tierEntries()) - 1));
        freeList.clearRange(fromPos, (fromPos + chunks));
        if (fromPos < (lowestPossiblyFreeChunk()))
            lowestPossiblyFreeChunk(fromPos);
        
    }

    public void freeExtra(long pos, int oldChunks, int newChunks) {
        long from = pos + newChunks;
        freeList.clearRange(from, (pos + oldChunks));
        if (from < (lowestPossiblyFreeChunk()))
            lowestPossiblyFreeChunk(from);
        
    }

    public void incrementModCount() {
        contextModCount = rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (localLockState) {
            case UNLOCKED :
                return ;
            case READ_LOCKED :
                int newTotalReadLockCount = decrementRead();
                if (newTotalReadLockCount == 0) {
                    if ((updateZero()) && (writeZero()))
                        segmentHeader().readUnlock(segmentHeaderAddress());
                    
                } else {
                    assert newTotalReadLockCount > 0 : "read underflow";
                }
                return ;
            case UPDATE_LOCKED :
                int newTotalUpdateLockCount = decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (writeZero()) {
                        if (readZero()) {
                            segmentHeader().updateUnlock(segmentHeaderAddress());
                        } else {
                            segmentHeader().downgradeUpdateToReadLock(segmentHeaderAddress());
                        }
                    } 
                } else {
                    assert newTotalUpdateLockCount > 0 : "update underflow";
                }
                return ;
            case WRITE_LOCKED :
                int newTotalWriteLockCount = decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!(updateZero())) {
                        segmentHeader().downgradeWriteToUpdateLock(segmentHeaderAddress());
                    } else {
                        if (!(readZero())) {
                            segmentHeader().downgradeWriteToReadLock(segmentHeaderAddress());
                        } else {
                            segmentHeader().writeUnlock(segmentHeaderAddress());
                        }
                    }
                } else {
                    assert newTotalWriteLockCount > 0 : "write underflow";
                }
        }
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        boolean isLocked = ((localLockState) != (LocalLockState.UNLOCKED)) && ((localLockState) != null);
        boolean goingToLock = (newState != (LocalLockState.UNLOCKED)) && (newState != null);
        if (isLocked) {
            if (!goingToLock)
                deregisterIterationContextLockedInThisThread();
            
        } else if (goingToLock) {
            registerIterationContextLockedInThisThread();
        } 
        localLockState = newState;
    }

    @Override
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(CompiledMapIterationContext.SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    final Thread owner;

    public Thread owner() {
        return this.owner;
    }

    public Bytes segmentBytesForRead() {
        segmentBytes.readLimit(segmentBytes.capacity());
        return segmentBytes;
    }

    public Bytes segmentBytesForWrite() {
        segmentBytes.readPosition(0);
        return segmentBytes;
    }

    private void closeNestedLocks() {
        unlinkFromSegmentContextsChain();
        readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        verifyInnermostContext();
        switch (localLockState) {
            case UNLOCKED :
                return ;
            case READ_LOCKED :
                segmentHeader().readUnlock(segmentHeaderAddress());
                return ;
            case UPDATE_LOCKED :
                segmentHeader().updateUnlock(segmentHeaderAddress());
                return ;
            case WRITE_LOCKED :
                segmentHeader().writeUnlock(segmentHeaderAddress());
        }
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = rootContextLockedOnThisSegment;
        while (true) {
            checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if ((innermostContextOnThisSegment.nextNode()) == null)
                break;
            
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface prevContext = rootContextLockedOnThisSegment;
        while (true) {
            assert (prevContext.nextNode()) != null;
            if ((prevContext.nextNode()) == (this))
                break;
            
            prevContext = prevContext.nextNode();
        }
        verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if ((nextNode) != null)
            throw new IllegalStateException("Attempt to close contexts not structurally");
        
    }

    public String debugContextsAndLocks() {
        String message = "";
        message += "Contexts locked on this segment:\n";
        for (LocksInterface cxt = rootContextLockedOnThisSegment ; cxt != null ; cxt = cxt.nextNode()) {
            message += (cxt.debugLocksState()) + "\n";
        }
        message += "Current thread contexts:\n";
        for (int i = 0, size = this.contextChain.size() ; i < size ; i++) {
            LocksInterface cxt = this.contextAtIndexInChain(i);
            message += (cxt.debugLocksState()) + "\n";
        }
        return message;
    }

    public boolean readZero() {
        return (rootContextLockedOnThisSegment.totalReadLockCount()) == 0;
    }

    public boolean realloc(long fromPos, int oldChunks, int newChunks) {
        if (((fromPos + newChunks) < (this.h().actualChunksPerSegmentTier)) && (freeList.isRangeClear((fromPos + oldChunks), (fromPos + newChunks)))) {
            freeList.setRange((fromPos + oldChunks), (fromPos + newChunks));
            return true;
        } else {
            return false;
        }
    }

    public boolean updateZero() {
        return (rootContextLockedOnThisSegment.totalUpdateLockCount()) == 0;
    }

    public boolean writeZero() {
        return (rootContextLockedOnThisSegment.totalWriteLockCount()) == 0;
    }

    private long _HashEntryStages_entryEnd() {
        return keyEnd();
    }

    public final int indexInContextChain;

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public final ReadLock innerReadLock;

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public static final Logger LOG = LoggerFactory.getLogger(CompiledMapIterationContext.class);

    public final WriteLock innerWriteLock;

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public final SizedReader<K> keyReader;

    public final UpdateLock innerUpdateLock;

    public final SizedReader<V> valueReader;

    public SizedReader<V> valueReader() {
        return this.valueReader;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public SizedReader<K> keyReader() {
        return this.keyReader;
    }

    public final ChainingInterface rootContextInThisThread;

    final EntryKeyBytesData entryKey;

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ChainingInterface rootContextInThisThread() {
        return this.rootContextInThisThread;
    }

    final WrappedValueInstanceDataHolder wrappedValueInstanceValueHolder;

    public WrappedValueInstanceDataHolder wrappedValueInstanceValueHolder() {
        return this.wrappedValueInstanceValueHolder;
    }

    final HashEntryChecksumStrategy hashEntryChecksumStrategy;

    public HashEntryChecksumStrategy hashEntryChecksumStrategy() {
        return this.hashEntryChecksumStrategy;
    }

    public final List<ChainingInterface> contextChain;

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    public final EntryValueBytesData entryValue;

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    private final VanillaChronicleMap<K, V, R> m;

    private final ReusableBitSet freeList;

    public ReusableBitSet freeList() {
        return this.freeList;
    }

    public final PointerBytesStore segmentBS;

    public final ChecksumStrategy checksumStrategy;

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public final Bytes segmentBytes;

    public Bytes segmentBytes() {
        return this.segmentBytes;
    }

    private void deregisterIterationContextLockedInThisThread() {
        if ((this) instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = false;
        } 
    }

    public void closeIterationSegmentStagesDeregisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public <T>T contextAtIndexInChain(int index) {
        return ((T)(contextChain.get(index)));
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    public Object entryForIteration() {
        return this;
    }

    @Override
    public <T extends ChainingInterface>T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        for (ChainingInterface context : contextChain) {
            if (((context.getClass()) == contextClass) && (!(context.usedInit()))) {
                context.initUsed(true);
                return ((T)(context));
            } 
        }
        int maxNestedContexts = 1 << 10;
        if ((contextChain.size()) > maxNestedContexts) {
            throw new IllegalStateException((((((("More than " + maxNestedContexts) + " nested ChronicleHash contexts are not supported. Very probable that ") + "you simply forgot to close context somewhere (recommended to use ") + "try-with-resources statement). ") + "Otherwise this is a bug, please report with this ") + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues"));
        } 
        T context = createChaining.apply(this);
        context.initUsed(true);
        return context;
    }

    @NotNull
    @Override
    public CompiledMapIterationContext<K, V, R> context() {
        return this;
    }

    public void checkAccessingFromOwnerThread() {
        if ((owner) != (Thread.currentThread())) {
            throw new ConcurrentModificationException("Context shouldn\'t be accessed from multiple threads");
        } 
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException(("Update or Write locking is forbidden in the context" + "of locked iteration context"));
        } 
    }

    public void checkEntryNotRemovedOnThisIteration() {
        if (entryRemovedOnThisIterationInit())
            throw new IllegalStateException("Entry was already removed on this iteration");
        
    }

    public void closeMapSegmentIterationCheckEntryNotRemovedOnThisIterationDependants() {
        this.closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        _CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.checkEntryNotRemovedOnThisIteration();
    }

    public void closeIterationCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public boolean checkSum() {
        this.checkOnEachPublicOperation();
        if (!(this.h().checksumEntries)) {
            throw new UnsupportedOperationException("Checksum is not stored in this Chronicle Hash");
        } 
        return (delayedUpdateChecksumInit()) || (checksumStrategy.innerCheckSum());
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceDataHolder wrapped = this.wrappedValueInstanceValueHolder;
        wrapped = wrapped.getUnusedWrappedValueHolderGuarded();
        wrapped.initValue(value);
        return wrapped.wrappedData();
    }

    @NotNull
    @Override
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public void updateChecksum() {
        this.checkOnEachPublicOperation();
        if (!(this.h().checksumEntries)) {
            throw new UnsupportedOperationException("Checksum is not stored in this Chronicle Hash");
        } 
        initDelayedUpdateChecksum(true);
    }

    @NotNull
    @Override
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @NotNull
    @Override
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @NotNull
    @Override
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @NotNull
    @Override
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    public VanillaChronicleMap<K, V, R> m() {
        return m;
    }

    public void closeVanillaChronicleMapHolderImplMDependants() {
        this.closeValueSize();
        this.wrappedValueInstanceValueHolder.closeValue();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return ((this.m().keySizeMarshaller.storingLength(keySize)) + keySize) + (this.m().valueSizeMarshaller.storingLength(valueSize));
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        long sizeWithoutChecksum;
        if (this.m().constantlySizedEntry) {
            sizeWithoutChecksum = VanillaChronicleMap.alignAddr((sizeOfEverythingBeforeValue + valueSize), this.m().alignment);
        } else if (this.m().couldNotDetermineAlignmentBeforeAllocation) {
            sizeWithoutChecksum = (sizeOfEverythingBeforeValue + (this.m().worstAlignment)) + valueSize;
        } else {
            sizeWithoutChecksum = (VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue, this.m().alignment)) + valueSize;
        }
        return sizeWithoutChecksum + (checksumStrategy.extraEntryBytes());
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = sizeOfEverythingBeforeValue(keySize, valueSize);
        return innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    @Override
    public Data<V> defaultValue(@NotNull
    MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    public R replaceValue(@NotNull
    MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    public ChronicleMap<K, V> map() {
        return m();
    }

    @Override
    public R remove(@NotNull
    MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @Override
    public R insert(@NotNull
    MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    public long newEntrySize(Data<V> newValue, long entryStartOffset, long newValueOffset) {
        return (((checksumStrategy.extraEntryBytes()) + newValueOffset) + (newValue.size())) - entryStartOffset;
    }

    @Override
    public ChronicleSet<K> set() {
        return m.chronicleSet;
    }

    public ChronicleHash<K, ?, ?, ?> hash() {
        return (set()) != null ? set() : map();
    }

    private void registerIterationContextLockedInThisThread() {
        if ((this) instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = true;
        } 
    }

    public void closeIterationSegmentStagesRegisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    long searchKey = CompactOffHeapLinearHashTable.UNSET_KEY;

    public long searchStartPos;

    public boolean searchKeyInit() {
        return (this.searchKey) != (CompactOffHeapLinearHashTable.UNSET_KEY);
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        searchStartPos = hl().hlPos(searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        assert this.searchKeyInit() : "SearchKey should be init";
        return this.searchKey;
    }

    public long searchStartPos() {
        assert this.searchKeyInit() : "SearchKey should be init";
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!(this.searchKeyInit()))
            return ;
        
        this.closeSearchKeyDependants();
        this.searchKey = CompactOffHeapLinearHashTable.UNSET_KEY;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeHashLookupSearchNextPosDependants();
    }

    public boolean shouldTestEntry() {
        return true;
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError(("putValueDeletedEntry() might be called only from " + "non-Replicated Map query context"));
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return contextChain;
    }

    public int allocatedChunks = 0;

    public boolean allocatedChunksInit() {
        return (this.allocatedChunks) != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert this.allocatedChunksInit() : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!(this.allocatedChunksInit()))
            return ;
        
        this.allocatedChunks = 0;
    }

    public long keyOffset = -1;

    public boolean keyOffsetInit() {
        return (this.keyOffset) != (-1);
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert this.keyOffsetInit() : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!(this.keyOffsetInit()))
            return ;
        
        this.closeKeyOffsetDependants();
        this.keyOffset = -1;
    }

    public void closeKeyOffsetDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public long keySize = -1;

    public boolean keySizeInit() {
        return (this.keySize) != (-1);
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert this.keySizeInit() : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!(this.keySizeInit()))
            return ;
        
        this.closeKeySizeDependants();
        this.keySize = -1;
    }

    public void closeKeySizeDependants() {
        this.closeMapEntryStagesKeyEndDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    public long keyEnd() {
        return (keyOffset()) + (keySize());
    }

    public void closeMapEntryStagesKeyEndDependants() {
        this.closeMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapEntryStagesEntryEndDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    long countValueSizeOffset() {
        return keyEnd();
    }

    public void closeMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public long valueSizeOffset = -1;

    public boolean valueSizeOffsetInit() {
        return (this.valueSizeOffset) != (-1);
    }

    void initValueSizeOffset() {
        valueSizeOffset = countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!(this.valueSizeOffsetInit()))
            this.initValueSizeOffset();
        
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!(this.valueSizeOffsetInit()))
            return ;
        
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public long hashLookupEntry = 0;

    public boolean hashLookupEntryInit() {
        return (this.hashLookupEntry) != 0;
    }

    public void initHashLookupEntry(long entry) {
        hashLookupEntry = entry;
    }

    public long hashLookupEntry() {
        assert this.hashLookupEntryInit() : "HashLookupEntry should be init";
        return this.hashLookupEntry;
    }

    void closeHashLookupEntry() {
        if (!(this.hashLookupEntryInit()))
            return ;
        
        this.hashLookupEntry = 0;
    }

    public int segmentIndex = -1;

    public boolean segmentIndexInit() {
        return (this.segmentIndex) >= 0;
    }

    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeSegmentIndexDependants();
    }

    public int segmentIndex() {
        assert this.segmentIndexInit() : "SegmentIndex should be init";
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!(this.segmentIndexInit()))
            return ;
        
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentTier();
        this.closeSegmentHeader();
    }

    public int tier = -1;

    public long tierIndex;

    public long tierBaseAddr;

    public boolean segmentTierInit() {
        return (this.tier) >= 0;
    }

    public void initSegmentTier() {
        tierIndex = (segmentIndex()) + 1;
        tierBaseAddr = this.h().segmentBaseAddr(segmentIndex());
        tier = 0;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier_WithBaseAddr(int tier, long tierBaseAddr, long tierIndex) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    private void initSegmentTier(int tier, long tierIndex) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        assert tierIndex > 0;
        this.tierBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        this.closeSegmentTierDependants();
    }

    public int tier() {
        if (!(this.segmentTierInit()))
            this.initSegmentTier();
        
        return this.tier;
    }

    public long tierBaseAddr() {
        if (!(this.segmentTierInit()))
            this.initSegmentTier();
        
        return this.tierBaseAddr;
    }

    public long tierIndex() {
        if (!(this.segmentTierInit()))
            this.initSegmentTier();
        
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!(this.segmentTierInit()))
            return ;
        
        this.closeSegmentTierDependants();
        this.tier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeKeyHash();
        this.closeHashLookupPos();
        this.closeHashLookupSearchAddrDependants();
        this.closeIterationSegmentStagesTierCountersAreaAddrDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeSegment();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    long keyHash = 0;

    public boolean keyHashInit() {
        return (this.keyHash) != 0;
    }

    void initKeyHash() {
        long addr = (this.tierBaseAddr()) + (this.keyOffset());
        long len = this.keySize();
        keyHash = LongHashFunction.xx_r39().hashMemory(addr, len);
        this.closeKeyHashDependants();
    }

    public long keyHash() {
        if (!(this.keyHashInit()))
            this.initKeyHash();
        
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!(this.keyHashInit()))
            return ;
        
        this.closeKeyHashDependants();
        this.keyHash = 0;
    }

    public void closeKeyHashDependants() {
        this.closeIterationKeyHashCodeKeyHashCodeDependants();
    }

    @Override
    public long keyHashCode() {
        return keyHash();
    }

    public void closeIterationKeyHashCodeKeyHashCodeDependants() {
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
    }

    private long addr() {
        return this.tierBaseAddr();
    }

    public void closeHashLookupSearchAddrDependants() {
        this.closeHashLookupSearchNextPosDependants();
    }

    public long tierCountersAreaAddr() {
        return (tierBaseAddr()) + (this.h().tierHashLookupOuterSize);
    }

    public void closeIterationSegmentStagesTierCountersAreaAddrDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(tierCountersAreaAddr());
    }

    public void prevTier() {
        if ((tier()) == 0)
            throw new IllegalStateException("first tier doesn\'t have previous");
        
        initSegmentTier(((tier()) - 1), prevTierIndex());
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(tierCountersAreaAddr(), prevTierIndex);
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(tierCountersAreaAddr());
    }

    public boolean hasNextTier() {
        return (nextTierIndex()) != 0;
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(tierCountersAreaAddr(), nextTierIndex);
    }

    public void goToFirstTier() {
        while ((tier()) != 0) {
            prevTier();
        }
    }

    long segmentHeaderAddress;

    SegmentHeader segmentHeader = null;

    public boolean segmentHeaderInit() {
        return (this.segmentHeader) != null;
    }

    private void initSegmentHeader() {
        segmentHeaderAddress = this.h().segmentHeaderAddress(segmentIndex());
        segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegmentHeaderDependants();
    }

    public long segmentHeaderAddress() {
        if (!(this.segmentHeaderInit()))
            this.initSegmentHeader();
        
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!(this.segmentHeaderInit()))
            this.initSegmentHeader();
        
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!(this.segmentHeaderInit()))
            return ;
        
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeIterationSegmentStagesTierEntriesDependants();
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
        this.closeIterationSegmentStagesLowestPossiblyFreeChunkDependants();
    }

    public long tierEntries() {
        if ((tier()) == 0) {
            return segmentHeader().entries(segmentHeaderAddress());
        } else {
            return TierCountersArea.entries(tierCountersAreaAddr());
        }
    }

    public long tierEntriesForIteration() {
        return this.tierEntries();
    }

    public void tierEntries(long tierEntries) {
        if ((tier()) == 0) {
            segmentHeader().entries(segmentHeaderAddress(), tierEntries);
        } else {
            TierCountersArea.entries(tierCountersAreaAddr(), tierEntries);
        }
    }

    public void closeIterationSegmentStagesTierEntriesDependants() {
        this.closeSegment();
    }

    public long tierDeleted() {
        if ((tier()) == 0) {
            return segmentHeader().deleted(segmentHeaderAddress());
        } else {
            return TierCountersArea.deleted(tierCountersAreaAddr());
        }
    }

    public void tierDeleted(long tierDeleted) {
        if ((tier()) == 0) {
            segmentHeader().deleted(segmentHeaderAddress(), tierDeleted);
        } else {
            TierCountersArea.deleted(tierCountersAreaAddr(), tierDeleted);
        }
    }

    long lowestPossiblyFreeChunk() {
        if ((tier()) == 0) {
            return segmentHeader().lowestPossiblyFreeChunk(segmentHeaderAddress());
        } else {
            return TierCountersArea.lowestPossiblyFreeChunkTiered(tierCountersAreaAddr());
        }
    }

    public void closeIterationSegmentStagesLowestPossiblyFreeChunkDependants() {
        this.closeSegment();
    }

    public void lowestPossiblyFreeChunk(long lowestPossiblyFreeChunk) {
        if ((tier()) == 0) {
            segmentHeader().lowestPossiblyFreeChunk(segmentHeaderAddress(), lowestPossiblyFreeChunk);
        } else {
            TierCountersArea.lowestPossiblyFreeChunkTiered(tierCountersAreaAddr(), lowestPossiblyFreeChunk);
        }
    }

    long entrySpaceOffset = 0;

    boolean segmentInit() {
        return (entrySpaceOffset) > 0;
    }

    void initSegment() {
        VanillaChronicleHash<?, ?, ?, ?> h = this.h();
        long segmentBaseAddr = this.tierBaseAddr();
        segmentBS.set(segmentBaseAddr, h.tierSize);
        segmentBytes.clear();
        long freeListOffset = (h.tierHashLookupOuterSize) + (VanillaChronicleHash.TIER_COUNTERS_AREA_SIZE);
        freeList.setOffset((segmentBaseAddr + freeListOffset));
        entrySpaceOffset = (freeListOffset + (h.tierFreeListOuterSize)) + (h.tierEntrySpaceInnerOffset);
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return this.entrySpaceOffset;
    }

    public PointerBytesStore segmentBS() {
        if (!(this.segmentInit()))
            this.initSegment();
        
        return this.segmentBS;
    }

    void closeSegment() {
        if (!(this.segmentInit()))
            return ;
        
        this.closeSegmentDependants();
        entrySpaceOffset = 0;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.closeEntryOffset();
        this.closeMapEntryStagesReadExistingEntryDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public long valueSize = -1;

    public long valueOffset;

    public boolean valueSizeInit() {
        return (this.valueSize) != (-1);
    }

    void initValueSize() {
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(valueSizeOffset());
        valueSize = this.m().readValueSize(segmentBytes);
        long currentPosition = segmentBytes.readPosition();
        long currentAddr = segmentBytes.address(currentPosition);
        long skip = (VanillaChronicleMap.alignAddr(currentAddr, this.m().alignment)) - currentAddr;
        if (skip > 0)
            segmentBytes.readSkip(skip);
        
        valueOffset = segmentBytes.readPosition();
        this.closeValueSizeDependants();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize(segmentBytes, valueSize);
        long currentPosition = segmentBytes.writePosition();
        long currentAddr = segmentBytes.address(currentPosition);
        long skip = (VanillaChronicleMap.alignAddr(currentAddr, this.m().alignment)) - currentAddr;
        if (skip > 0)
            segmentBytes.writeSkip(skip);
        
        valueOffset = segmentBytes.writePosition();
        this.closeValueSizeDependants();
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        valueSize = oldValueSize;
        valueOffset = (valueSizeOffset()) + (oldValueOffset - oldValueSizeOffset);
        this.closeValueSizeDependants();
    }

    public long valueOffset() {
        if (!(this.valueSizeInit()))
            this.initValueSize();
        
        return this.valueOffset;
    }

    public long valueSize() {
        if (!(this.valueSizeInit()))
            this.initValueSize();
        
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!(this.valueSizeInit()))
            return ;
        
        this.closeValueSizeDependants();
        this.valueSize = -1;
    }

    public void closeValueSizeDependants() {
        this.closeMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    protected long entryEnd() {
        return (valueOffset()) + (valueSize());
    }

    public void closeMapEntryStagesEntryEndDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeChecksumDependants();
        this.hashEntryChecksumStrategy.closeHashEntryChecksumStrategyComputeAndStoreChecksumDependants();
    }

    public void writeValue(Data<?> value) {
        initDelayedUpdateChecksum(true);
        RandomDataInput valueBytes = value.bytes();
        if ((valueBytes instanceof NativeBytesStore) && ((valueBytes.address(value.offset())) == (this.segmentBS().address(valueOffset())))) {
            return ;
        } 
        value.writeTo(this.segmentBS(), valueOffset());
    }

    public void initValue(Data<?> value) {
        initValueSize(value.size());
        writeValue(value);
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert oldValueSize == (value.size());
        initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        writeValue(value);
    }

    public void nextTier() {
        _SegmentStages_nextTier();
        if (this.hashLookupEntryInit())
            this.initSearchKey(this.h().hashLookup.key(this.hashLookupEntry()));
        
    }

    public void goToLastTier() {
        while (hasNextTier()) {
            nextTier();
        }
    }

    public long size() {
        goToFirstTier();
        long size = (tierEntries()) - (tierDeleted());
        while (hasNextTier()) {
            nextTier();
            size += (tierEntries()) - (tierDeleted());
        }
        return size;
    }

    @Override
    public long alloc(int chunks, long prevPos, int prevChunks) {
        long ret = this.allocReturnCodeGuarded(chunks);
        if (prevPos >= 0)
            this.freeGuarded(prevPos, prevChunks);
        
        if (ret >= 0)
            return ret;
        
        while (true) {
            this.nextTier();
            ret = this.allocReturnCodeGuarded(chunks);
            if (ret >= 0)
                return ret;
            
        }
    }

    public void verifyTierCountersAreaData() {
        goToFirstTier();
        while (true) {
            int tierSegmentIndex = TierCountersArea.segmentIndex(tierCountersAreaAddr());
            if (tierSegmentIndex != (segmentIndex())) {
                throw new AssertionError(((((((((("segmentIndex: " + (segmentIndex())) + ", tier: ") + (tier())) + ", tierIndex: ") + (tierIndex())) + ", tierBaseAddr: ") + (tierBaseAddr())) + " reports it belongs to segmentIndex ") + tierSegmentIndex));
            } 
            if (hasNextTier()) {
                long currentTierIndex = this.tierIndex();
                nextTier();
                if ((prevTierIndex()) != currentTierIndex) {
                    throw new AssertionError(((((((((((("segmentIndex: " + (segmentIndex())) + ", tier: ") + (tier())) + ", tierIndex: ") + (tierIndex())) + ", tierBaseAddr: ") + (tierBaseAddr())) + " reports the previous tierIndex is ") + (prevTierIndex())) + " while actually it is ") + currentTierIndex));
                } 
            } else {
                break;
            }
        }
    }

    boolean used;

    @Override
    public boolean usedInit() {
        return used;
    }

    @Override
    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!(this.usedInit()))
            return ;
        
        used = false;
    }

    public boolean entryRemovedOnThisIteration = false;

    boolean entryRemovedOnThisIterationInit() {
        return (this.entryRemovedOnThisIteration) != false;
    }

    protected void initEntryRemovedOnThisIteration(boolean entryRemovedOnThisIteration) {
        this.entryRemovedOnThisIteration = entryRemovedOnThisIteration;
    }

    public void closeEntryRemovedOnThisIteration() {
        if (!(this.entryRemovedOnThisIterationInit()))
            return ;
        
        this.entryRemovedOnThisIteration = false;
    }

    public Data<K> inputKey = null;

    boolean inputKeyInit() {
        return (this.inputKey) != null;
    }

    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Data<K> inputKey() {
        assert this.inputKeyInit() : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!(this.inputKeyInit()))
            return ;
        
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
    }

    public void closeIterationSegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    int totalReadLockCount;

    int totalUpdateLockCount;

    int totalWriteLockCount;

    public int latestSameThreadSegmentModCount;

    public int contextModCount;

    public boolean nestedContextsLockedOnSameSegment;

    LocksInterface nextNode;

    LocalLockState localLockState;

    public LocksInterface rootContextLockedOnThisSegment = null;

    public boolean locksInit() {
        return (this.rootContextLockedOnThisSegment) != null;
    }

    void initLocks() {
        localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (int i = indexOfThisContext - 1 ; i >= 0 ; i--) {
            if (tryFindInitLocksOfThisSegment(i))
                return ;
            
        }
        for (int i = indexOfThisContext + 1, size = this.contextChain.size() ; i < size ; i++) {
            if (tryFindInitLocksOfThisSegment(i))
                return ;
            
        }
        rootContextLockedOnThisSegment = this;
        nestedContextsLockedOnSameSegment = false;
        latestSameThreadSegmentModCount = 0;
        contextModCount = 0;
        totalReadLockCount = 0;
        totalUpdateLockCount = 0;
        totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean nestedContextsLockedOnSameSegment() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.nestedContextsLockedOnSameSegment;
    }

    public int latestSameThreadSegmentModCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.latestSameThreadSegmentModCount;
    }

    public int totalReadLockCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.totalReadLockCount;
    }

    public int totalUpdateLockCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.totalUpdateLockCount;
    }

    public int totalWriteLockCount() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.localLockState;
    }

    public LocksInterface nextNode() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.nextNode;
    }

    public LocksInterface rootContextLockedOnThisSegment() {
        if (!(this.locksInit()))
            this.initLocks();
        
        return this.rootContextLockedOnThisSegment;
    }

    void closeLocks() {
        if (!(this.locksInit()))
            return ;
        
        this.closeLocksDependants();
        if ((rootContextLockedOnThisSegment) == (this)) {
            closeRootLocks();
        } else {
            closeNestedLocks();
        }
        deregisterIterationContextLockedInThisThread();
        localLockState = null;
        rootContextLockedOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeDelayedUpdateChecksum();
    }

    public long hashLookupPos = -1;

    public boolean hashLookupPosInit() {
        return (this.hashLookupPos) != (-1);
    }

    public void initHashLookupPos() {
        if ((this.tier()) < 0)
            throw new AssertionError();
        
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!(this.hashLookupPosInit()))
            this.initHashLookupPos();
        
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!(this.hashLookupPosInit()))
            return ;
        
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1;
    }

    public void closeHashLookupPosDependants() {
        this.closeHashLookupSearchNextPosDependants();
        this.closeHashLookupSearchFoundDependants();
    }

    public long nextPos() {
        long pos = this.hashLookupPos();
        while (true) {
            long entry = hl().readEntry(addr(), pos);
            if (hl().empty(entry)) {
                this.setHashLookupPosGuarded(pos);
                return -1L;
            } 
            pos = hl().step(pos);
            if (pos == (searchStartPos()))
                break;
            
            if ((hl().key(entry)) == (searchKey())) {
                this.setHashLookupPosGuarded(pos);
                return hl().value(entry);
            } 
        }
        throw new IllegalStateException(("MultiMap is full, that most likely means you " + ("misconfigured entrySize/chunkSize, and entries tend to take less chunks than " + "expected")));
    }

    public void closeHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public void putValueVolatile(long newValue) {
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        hashLookup.checkValueForPut(newValue);
        hashLookup.putValueVolatile(this.tierBaseAddr(), hashLookupPos(), newValue);
    }

    public void found() {
        this.setHashLookupPosGuarded(hl().stepBack(this.hashLookupPos()));
    }

    public void closeHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = hl().readEntry(addr(), this.hashLookupPos());
        return ((hl().key(entry)) == (searchKey())) && ((hl().value(entry)) == value);
    }

    public void remove() {
        this.setHashLookupPosGuarded(hl().remove(addr(), this.hashLookupPos()));
    }

    @Override
    public String debugLocksState() {
        String s = (this) + ": ";
        if (!(this.usedInit())) {
            s += "unused";
            return s;
        } 
        s += "used, ";
        if (!(segmentIndexInit())) {
            s += "segment uninitialized";
            return s;
        } 
        s += ("segment " + (segmentIndex())) + ", ";
        if (!(locksInit())) {
            s += "locks uninitialized";
            return s;
        } 
        s += ("local state: " + (localLockState())) + ", ";
        s += ("read lock count: " + (rootContextLockedOnThisSegment().totalReadLockCount())) + ", ";
        s += ("update lock count: " + (rootContextLockedOnThisSegment().totalUpdateLockCount())) + ", ";
        s += "write lock count: " + (rootContextLockedOnThisSegment().totalWriteLockCount());
        return s;
    }

    boolean keyEquals() {
        return ((inputKey().size()) == (this.keySize())) && (BytesUtil.bytesEqual(this.segmentBS(), this.keyOffset(), inputKey().bytes(), inputKey().offset(), this.keySize()));
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    public long pos = -1;

    public boolean posInit() {
        return (this.pos) != (-1);
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    public long pos() {
        assert this.posInit() : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!(this.posInit()))
            return ;
        
        this.closePosDependants();
        this.pos = -1;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
    }

    public long keySizeOffset = -1;

    public boolean entryOffsetInit() {
        return (this.keySizeOffset) != (-1);
    }

    public void initEntryOffset() {
        keySizeOffset = (this.entrySpaceOffset()) + ((pos()) * (this.h().chunkSize));
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!(this.entryOffsetInit()))
            this.initEntryOffset();
        
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!(this.entryOffsetInit()))
            return ;
        
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1;
    }

    public void closeEntryOffsetDependants() {
        this.closeMapEntryStagesEntrySizeDependants();
        this.closeMapEntryStagesReadExistingEntryDependants();
        this.closeDelayedUpdateChecksum();
    }

    public void writeNewEntry(long pos, Data<?> key) {
        initPos(pos);
        initKeySize(key.size());
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(keySizeOffset());
        this.h().keySizeMarshaller.writeSize(segmentBytes, keySize());
        initKeyOffset(segmentBytes.writePosition());
        key.writeTo(this.segmentBS(), keyOffset());
    }

    long entrySize() {
        return ((checksumStrategy.extraEntryBytes()) + (entryEnd())) - (keySizeOffset());
    }

    public void closeMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public int entrySizeInChunks = 0;

    public boolean entrySizeInChunksInit() {
        return (this.entrySizeInChunks) != 0;
    }

    void initEntrySizeInChunks() {
        entrySizeInChunks = this.h().inChunks(entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!(this.entrySizeInChunksInit()))
            this.initEntrySizeInChunks();
        
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        if (!(this.entrySizeInChunksInit()))
            return ;
        
        this.entrySizeInChunks = 0;
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        initPos(newPos);
        initKeyOffset(((keySizeOffset()) + (oldKeyAddr - oldKeySizeAddr)));
        Access.copy(Access.nativeAccess(), null, oldKeySizeAddr, Access.checkedBytesStoreAccess(), this.segmentBS(), keySizeOffset(), bytesToCopy);
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy, long prevPos, int prevChunks) {
        initAllocatedChunks(this.h().inChunks(entrySize));
        long oldSegmentTierBaseAddr = this.tierBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + (this.keySizeOffset());
        long oldKeyAddr = oldSegmentTierBaseAddr + (this.keyOffset());
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(allocatedChunks(), prevPos, prevChunks);
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return (this.tier()) != tierBeforeAllocation;
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return ((valueSizeOffset()) + (this.m().valueSizeMarshaller.storingLength(newValue.size()))) - (keySizeOffset());
    }

    public void readExistingEntry(long pos) {
        initPos(pos);
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(keySizeOffset());
        initKeySize(this.h().keySizeMarshaller.readSize(segmentBytes));
        initKeyOffset(segmentBytes.readPosition());
    }

    public void closeMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    private <T>boolean forEachTierEntryWhile(Predicate<? super T> predicate, int currentTier, long currentTierBaseAddr, long tierIndex) {
        long leftEntries = tierEntriesForIteration();
        boolean interrupted = false;
        long startPos = 0L;
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        while (!(hashLookup.empty(hashLookup.readEntry(currentTierBaseAddr, startPos)))) {
            startPos = hashLookup.step(startPos);
        }
        this.initHashLookupPos(startPos);
        long currentHashLookupPos;
        int steps = 0;
        do {
            currentHashLookupPos = hashLookup.step(this.hashLookupPos());
            steps++;
            this.setHashLookupPosGuarded(currentHashLookupPos);
            long entry = hashLookup.readEntry(currentTierBaseAddr, currentHashLookupPos);
            initHashLookupEntry(entry);
            if (!(hashLookup.empty(entry))) {
                this.readExistingEntry(hashLookup.value(entry));
                if (shouldTestEntry()) {
                    initEntryRemovedOnThisIteration(false);
                    try {
                        if (!(predicate.test(((T)(entryForIteration()))))) {
                            interrupted = true;
                            break;
                        } else {
                            if ((--leftEntries) == 0)
                                break;
                            
                        }
                    } finally {
                        if ((this.tier()) != currentTier) {
                            this.initSegmentTier_WithBaseAddr(currentTier, currentTierBaseAddr, tierIndex);
                            currentHashLookupPos = hashLookup.stepBack(currentHashLookupPos);
                            steps--;
                            this.initHashLookupPos(currentHashLookupPos);
                        } 
                        this.closeKeyOffset();
                    }
                } 
            } 
        } while ((currentHashLookupPos != startPos) || (steps == 0) );
        if ((!interrupted) && (leftEntries > 0)) {
            throw new IllegalStateException(((("We a tier without interruption, " + "but according to tier counters there should be ") + leftEntries) + " more entries. Size diverged?"));
        } 
        return interrupted;
    }

    public <T>boolean innerForEachSegmentEntryWhile(Predicate<? super T> predicate) {
        try {
            this.goToLastTier();
            while (true) {
                int currentTier = this.tier();
                long currentTierBaseAddr = this.tierBaseAddr();
                long currentTierIndex = this.tierIndex();
                boolean interrupted = forEachTierEntryWhile(predicate, currentTier, currentTierBaseAddr, currentTierIndex);
                if (interrupted)
                    return false;
                
                if (currentTier == 0)
                    return true;
                
                this.prevTier();
            }
        } finally {
            closeHashLookupEntry();
            this.innerReadLock.unlock();
            initEntryRemovedOnThisIteration(false);
        }
    }

    @Override
    public boolean forEachSegmentEntryWhile(Predicate<? super MapEntry<K, V>> predicate) {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        return innerForEachSegmentEntryWhile(predicate);
    }

    @Override
    public void forEachSegmentEntry(Consumer<? super MapEntry<K, V>> action) {
        forEachSegmentEntryWhile((MapEntry<K, V> e) -> {
            action.accept(e);
            return true;
        });
    }

    protected CompiledMapIterationContext.SearchState searchState = null;

    boolean keySearchInit() {
        return (this.searchState) != null;
    }

    public void initKeySearch() {
        for (long pos ; (pos = this.nextPos()) >= 0L ; ) {
            if (inputKeyInit()) {
                this.readExistingEntry(pos);
                if (!(keyEquals()))
                    continue;
                
                this.found();
                keyFound();
                return ;
            } 
        }
        searchState = CompiledMapIterationContext.SearchState.ABSENT;
    }

    public CompiledMapIterationContext.SearchState searchState() {
        if (!(this.keySearchInit()))
            this.initKeySearch();
        
        return this.searchState;
    }

    void closeKeySearch() {
        if (!(this.keySearchInit()))
            return ;
        
        this.searchState = null;
    }

    public boolean searchStateDeleted() {
        return (((searchState()) == (CompiledMapIterationContext.SearchState.DELETED)) && (!(this.nestedContextsLockedOnSameSegment()))) && (this.innerUpdateLock.isHeldByCurrentThread());
    }

    public boolean searchStatePresent() {
        return (searchState()) == (CompiledMapIterationContext.SearchState.PRESENT);
    }

    public boolean searchStateAbsent() {
        return (!(searchStatePresent())) && (!(searchStateDeleted()));
    }

    public void putNewVolatile(long value) {
        if (this.searchStatePresent())
            throw new AssertionError();
        
        hl().checkValueForPut(value);
        long currentEntry = hl().readEntry(addr(), this.hashLookupPos());
        hl().writeEntryVolatile(addr(), this.hashLookupPos(), currentEntry, searchKey(), value);
    }

    public boolean delayedUpdateChecksum = false;

    boolean delayedUpdateChecksumInit() {
        return (this.delayedUpdateChecksum) != false;
    }

    public void initDelayedUpdateChecksum(boolean delayedUpdateChecksum) {
        assert (entryOffsetInit()) && ((keySizeOffset()) >= 0);
        assert (this.locksInit()) && ((this.localLockState()) != (LocalLockState.UNLOCKED));
        assert delayedUpdateChecksum;
        this.delayedUpdateChecksum = true;
    }

    public void closeDelayedUpdateChecksum() {
        if (!(this.delayedUpdateChecksumInit()))
            return ;
        
        if (this.h().checksumEntries)
            this.hashEntryChecksumStrategy.computeAndStoreChecksum();
        
        delayedUpdateChecksum = false;
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.freeGuarded(pos(), entrySizeInChunks());
        this.incrementModCountGuarded();
    }

    public void iterationRemove() {
        if ((this.h().hashLookup.remove(this.tierBaseAddr(), this.hashLookupPos())) != (this.hashLookupPos())) {
            this.setHashLookupPosGuarded(this.h().hashLookup.stepBack(this.hashLookupPos()));
        } 
        this.innerRemoveEntryExceptHashLookupUpdate();
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerWriteLock.lock();
        try {
            iterationRemove();
        } finally {
            this.innerWriteLock.unlock();
        }
        initEntryRemovedOnThisIteration(true);
    }

    public final void freeExtraAllocatedChunks() {
        if (((!(this.m().constantlySizedEntry)) && (this.m().couldNotDetermineAlignmentBeforeAllocation)) && ((entrySizeInChunks()) < (this.allocatedChunks()))) {
            this.freeExtraGuarded(pos(), this.allocatedChunks(), entrySizeInChunks());
        } else {
            initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.innerWriteLock.lock();
        long entrySize = innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.tierBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, ((valueSizeOffset()) - (keySizeOffset())), pos(), entrySizeInChunks());
        if (tierHasChanged) {
            if (!(this.searchStateAbsent()))
                throw new AssertionError();
            
        } 
        initValue(newValue);
        freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(pos());
        hl.writeEntryVolatile(this.tierBaseAddr(), this.hashLookupPos(), oldEntry, hl.key(oldEntry), pos());
        if (tierHasChanged)
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        
    }

    public void innerDefaultReplaceValue(Data<V> newValue) {
        assert this.innerUpdateLock.isHeldByCurrentThread();
        boolean newValueSizeIsDifferent = (newValue.size()) != (this.valueSize());
        if (newValueSizeIsDifferent) {
            long newSizeOfEverythingBeforeValue = newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = keySizeOffset();
            VanillaChronicleMap<?, ?, ?> m = this.m();
            long newValueOffset = VanillaChronicleMap.alignAddr((entryStartOffset + newSizeOfEverythingBeforeValue), this.m().alignment);
            long newEntrySize = newEntrySize(newValue, entryStartOffset, newValueOffset);
            int newSizeInChunks = m.inChunks(newEntrySize);
            newValueDoesNotFit : if (newSizeInChunks > (entrySizeInChunks())) {
                if (newSizeInChunks > (m.maxChunksPerEntry)) {
                    throw new IllegalArgumentException(((((("Value too large: " + "entry takes ") + newSizeInChunks) + " chunks, ") + (m.maxChunksPerEntry)) + " is maximum."));
                } 
                if (this.reallocGuarded(pos(), entrySizeInChunks(), newSizeInChunks)) {
                    break newValueDoesNotFit;
                } 
                relocation(newValue, newSizeOfEverythingBeforeValue);
                return ;
            } else if (newSizeInChunks < (entrySizeInChunks())) {
                this.freeExtraGuarded(pos(), entrySizeInChunks(), newSizeInChunks);
            } 
        } else {
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            initValue(newValue);
        } else {
            writeValue(newValue);
        }
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.checkOnEachPublicOperation();
        try {
            this.innerDefaultReplaceValue(newValue);
        } finally {
            this.innerWriteLock.unlock();
        }
    }

    public void writeValueAndPutPos(Data<V> value) {
        initValue(value);
        freeExtraAllocatedChunks();
        this.putValueVolatile(pos());
    }
}