/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.entry;

import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupPos;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class HashLookupSearch {
    @StageRef
    SegmentStages s;
    @StageRef
    public VanillaChronicleHashHolder<?> hh;
    @StageRef
    HashLookupPos hlp;
    @StageRef
    KeySearch<?> ks;
    @StageRef
    MapEntryStages<?, ?> e;
    @Stage(value="SearchKey")
    long searchKey = 0L;
    @Stage(value="SearchKey")
    public long searchStartPos;

    public CompactOffHeapLinearHashTable hl() {
        return this.hh.h().hashLookup;
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
    }

    private long addr() {
        return this.s.tierBaseAddr;
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hlp.hashLookupPos;
            do {
                entry = this.hl().readEntryVolatile(this.addr(), pos);
                if (this.hl().empty(entry)) {
                    this.hlp.setHashLookupPos(pos);
                    return -1L;
                }
                pos = this.hl().step(pos);
                if (pos == this.searchStartPos) break block2;
            } while (this.hl().key(entry) != this.searchKey);
            this.hlp.setHashLookupPos(pos);
            return this.hl().value(entry);
        }
        throw new IllegalStateException("HashLookup overflow should never occur");
    }

    public void found() {
        this.hlp.setHashLookupPos(this.hl().stepBack(this.hlp.hashLookupPos));
    }

    public void remove() {
        this.hlp.setHashLookupPos(this.hl().remove(this.addr(), this.hlp.hashLookupPos));
    }

    public void putNewVolatile(long entryPos) {
        boolean keySearchReInit;
        boolean bl = keySearchReInit = !this.ks.keySearchInit();
        if (this.ks.searchStatePresent()) {
            throw new AssertionError();
        }
        if (keySearchReInit) {
            this.e.readExistingEntry(entryPos);
        }
        this.hl().checkValueForPut(entryPos);
        this.hl().writeEntryVolatile(this.addr(), this.hlp.hashLookupPos, this.searchKey, entryPos);
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hlp.hashLookupPos);
        return this.hl().key(entry) == this.searchKey && this.hl().value(entry) == value;
    }
}

