/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.EnumMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ByteArraySizedReader implements SizedReader<byte[]>,
EnumMarshallable<ByteArraySizedReader>
{
    INSTANCE;


    @Override
    @NotNull
    public byte[] read(@NotNull Bytes in, long size, @Nullable byte[] using) {
        int resLen = this.resLen(size);
        if (using == null || resLen != using.length) {
            using = new byte[resLen];
        }
        in.read(using);
        return using;
    }

    private int resLen(long size) {
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byte[] size should be non-negative int, " + size + " given. Memory corruption?");
        }
        return (int)size;
    }

    public ByteArraySizedReader readResolve() {
        return INSTANCE;
    }
}

