/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.AcceptStrategy;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.tcp.ChronicleServerSocket;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptorEventHandler<T extends NetworkContext<T>>
extends AbstractCloseable
implements EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptorEventHandler.class);
    @NotNull
    private final Function<T, TcpEventHandler<T>> handlerFactory;
    @NotNull
    private final ChronicleServerSocketChannel ssc;
    @NotNull
    private final Supplier<T> ncFactory;
    private final String hostPort;
    private final AcceptStrategy acceptStrategy;
    private EventLoop eventLoop;

    public AcceptorEventHandler(@NotNull String hostPort, @NotNull Function<T, TcpEventHandler<T>> handlerFactory, @NotNull Supplier<T> ncFactory) throws IOException {
        this(hostPort, handlerFactory, ncFactory, AcceptStrategy.ACCEPT_ALL);
    }

    public AcceptorEventHandler(@NotNull String hostPort, @NotNull Function<T, TcpEventHandler<T>> handlerFactory, @NotNull Supplier<T> ncFactory, @NotNull AcceptStrategy acceptStrategy) throws IOException {
        this.handlerFactory = handlerFactory;
        this.hostPort = hostPort;
        this.ssc = TCPRegistry.acquireServerSocketChannel(this.hostPort);
        this.ncFactory = ncFactory;
        this.acceptStrategy = acceptStrategy;
    }

    public AcceptorEventHandler(@NotNull ChronicleServerSocketChannel ssc, @NotNull Function<T, TcpEventHandler<T>> handlerFactory, @NotNull Supplier<T> ncFactory, @NotNull AcceptStrategy acceptStrategy) throws IOException {
        this.handlerFactory = handlerFactory;
        this.hostPort = ssc.getLocalAddress().toString();
        this.ssc = ssc;
        this.ncFactory = ncFactory;
        this.acceptStrategy = acceptStrategy;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public boolean action() throws InvalidEventHandlerException {
        if (!this.ssc.isOpen() || this.isClosed() || this.eventLoop.isClosing()) {
            throw new InvalidEventHandlerException();
        }
        try {
            LOGGER.debug("accepting {}", (Object)this.ssc);
            ChronicleSocketChannel sc = this.acceptStrategy.accept(this.ssc);
            if (sc != null) {
                if (this.isClosed() || this.eventLoop.isClosing()) {
                    Closeable.closeQuietly((Object)sc);
                    throw new InvalidEventHandlerException("closed");
                }
                NetworkContext nc = (NetworkContext)this.ncFactory.get();
                nc.socketChannel(sc);
                nc.isAcceptor(true);
                NetworkStatsListener nl = nc.networkStatsListener();
                NetworkStatsListener.notifyHostPort(sc, nl);
                TcpEventHandler<T> apply = this.handlerFactory.apply(nc);
                this.eventLoop.addHandler(apply);
            }
        }
        catch (AsynchronousCloseException e) {
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (ClosedChannelException e) {
            this.closeSocket();
            if (this.isClosed()) {
                throw new InvalidEventHandlerException();
            }
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (Exception e) {
            if (!this.isClosed() && !this.eventLoop.isClosing()) {
                ChronicleServerSocket socket = this.ssc.socket();
                LOGGER.warn("{}, port={}", new Object[]{this.hostPort, socket == null ? "unknown" : Integer.valueOf(socket.getLocalPort()), e});
            }
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        return false;
    }

    private void closeSocket() {
        if (this.ssc != null) {
            Closeable.closeQuietly((Object[])new Object[]{this.ssc.socket(), this.ssc});
        }
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    protected void performClose() {
        this.closeSocket();
    }
}

