/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.NetworkUtil;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.api.session.SubHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;

public class HeaderTcpHandler<T extends NetworkContext<T>>
extends SimpleCloseable
implements TcpHandler<T> {
    public static final String HANDLER = "handler";
    @NotNull
    private final TcpEventHandler<T> handlerManager;
    @NotNull
    private final Function<Object, TcpHandler<T>> handlerFunction;

    public HeaderTcpHandler(@NotNull TcpEventHandler<T> handlerManager, @NotNull Function<Object, TcpHandler<T>> handlerFunction) {
        this.handlerManager = handlerManager;
        this.handlerFunction = handlerFunction;
    }

    @Override
    public void process(@NotNull Bytes<?> in, @NotNull Bytes<?> out, @NotNull T nc) {
        this.throwExceptionIfClosed();
        WireType wireType = nc.wireType() == null ? WireType.BINARY : nc.wireType();
        Wire inWire = (Wire)wireType.apply(in);
        inWire.usePadding(NetworkUtil.TCP_USE_PADDING);
        long start = in.readPosition();
        Object o = null;
        try (DocumentContext dc = inWire.readingDocument();){
            if (!dc.isPresent()) {
                return;
            }
            if (YamlLogging.showServerReads()) {
                Jvm.startup().on(this.getClass(), "nc.isAcceptor=" + nc.isAcceptor() + ", read:\n" + Wires.fromSizePrefixedBlobs(in, (long)start, (long)(in.readLimit() - start)));
            }
            long readPosition = inWire.bytes().readPosition();
            @NotNull ValueIn read = inWire.read(() -> HANDLER);
            if (dc.isMetaData() && read.isTyped()) {
                o = read.typedMarshallable();
            } else {
                inWire.bytes().readPosition(readPosition);
                o = this.toSessionDetails(inWire);
            }
            TcpHandler<T> handler = this.handlerFunction.apply(o);
            if (handler instanceof NetworkContextManager) {
                ((NetworkContextManager)((Object)handler)).nc(nc);
            }
            this.handlerManager.tcpHandler(handler);
        }
        catch (Throwable e) {
            if (this.isClosed()) {
                return;
            }
            Jvm.pause((long)50L);
            if (this.isClosed()) {
                return;
            }
            if (o instanceof SubHandler) {
                Jvm.warn().on(this.getClass(), "SubHandler " + o + " sent before UberHandler, closing.");
                this.close();
            }
            Jvm.warn().on(this.getClass(), "wirein=" + Wires.fromSizePrefixedBlobs((WireIn)inWire), e);
        }
    }

    @NotNull
    private SessionDetailsProvider toSessionDetails(@NotNull Wire inWire) {
        @NotNull VanillaSessionDetails sd = new VanillaSessionDetails();
        sd.readMarshallable((WireIn)inWire);
        return sd;
    }
}

