/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.time.ZoneId;
import java.util.Objects;
import net.openhft.chronicle.queue.RollCycles;
import org.jetbrains.annotations.NotNull;

public interface RollCycle {
    public static RollCycle forLength(int length) {
        for (int i = RollCycles.VALUES.length - 1; i >= 0; --i) {
            if (RollCycles.VALUES[i].length != length) continue;
            return RollCycles.VALUES[i];
        }
        throw new IllegalArgumentException("Unknown value for CycleLength (" + length + ")");
    }

    public static RollCycle forFormat(String format) {
        for (int i = RollCycles.VALUES.length - 1; i >= 0; --i) {
            if (!Objects.equals(RollCycles.VALUES[i].format, format) && !RollCycles.VALUES[i].format.equals(format)) continue;
            return RollCycles.VALUES[i];
        }
        throw new IllegalArgumentException("Unknown value for CycleFormat (" + format + ")");
    }

    @NotNull
    public static RollCycle from(final int length, final @NotNull String format, final @NotNull ZoneId zone) {
        return new RollCycle(){

            @Override
            @NotNull
            public String format() {
                return format;
            }

            @Override
            public int length() {
                return length;
            }

            @Override
            @NotNull
            public ZoneId zone() {
                return zone;
            }
        };
    }

    public String format();

    public int length();

    public ZoneId zone();

    default public int current(long epoch) {
        return (int)((System.currentTimeMillis() - epoch) / (long)this.length());
    }
}

