/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.queue.RollCycle;
import org.jetbrains.annotations.NotNull;

public class RollingResourcesCache {
    private static final int SIZE = 32;
    @NotNull
    private final Function<String, File> fileFactory;
    @NotNull
    private final DateTimeFormatter formatter;
    @NotNull
    private final Resource[] values;
    private final int length;
    @NotNull
    private final Function<File, String> fileToName;

    public RollingResourcesCache(@NotNull RollCycle cycle, long epoch, @NotNull Function<String, File> nameToFile, @NotNull Function<File, String> fileToName) {
        this(cycle.length(), cycle.format(), epoch, nameToFile, fileToName);
    }

    private RollingResourcesCache(int length, @NotNull String format, long epoch, @NotNull Function<String, File> nameToFile, @NotNull Function<File, String> fileToName) {
        this.length = length;
        this.fileToName = fileToName;
        this.values = new Resource[32];
        long millis = (epoch + 43200000L) % 86400000L - 43200000L;
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds((int)(millis / 1000L));
        ZoneId zoneId = ZoneId.ofOffset("GMT", zoneOffset);
        this.formatter = DateTimeFormatter.ofPattern(format).withZone(zoneId);
        this.fileFactory = nameToFile;
    }

    @NotNull
    public Resource resourceFor(long cycle) {
        long millis = cycle * (long)this.length;
        int hash = Maths.hash32((long)millis) & 0x1F;
        Resource dv = this.values[hash];
        if (dv == null || dv.millis != millis) {
            String text = this.formatter.format(Instant.ofEpochMilli(millis));
            this.values[hash] = dv = new Resource(millis, text, this.fileFactory.apply(text));
        }
        return dv;
    }

    public int parseCount(@NotNull String name) {
        TemporalAccessor parse = this.formatter.parse(name);
        long epochDay = parse.getLong(ChronoField.EPOCH_DAY) * 86400L;
        if (parse.isSupported(ChronoField.SECOND_OF_DAY)) {
            epochDay += parse.getLong(ChronoField.SECOND_OF_DAY);
        }
        return Maths.toInt32((long)(epochDay / (long)(this.length / 1000)));
    }

    public Long toLong(File file) {
        TemporalAccessor parse = this.formatter.parse(this.fileToName.apply(file));
        if ((long)this.length == 86400000L) {
            return parse.getLong(ChronoField.EPOCH_DAY);
        }
        return Instant.from(parse).toEpochMilli() / (long)this.length;
    }

    public static class Resource {
        public final long millis;
        public final String text;
        public final File path;

        Resource(long millis, String text, File path) {
            this.millis = millis;
            this.text = text;
            this.path = path;
        }
    }
}

