/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;

public final class MessageToTextQueueEntryHandler
implements QueueEntryHandler {
    private final Bytes textConversionTarget = Bytes.elasticByteBuffer();

    @Override
    public void accept(WireIn wireIn, Consumer<String> messageHandler) {
        String text;
        Bytes serialisedMessage = wireIn.bytes();
        byte dataFormatIndicator = serialisedMessage.readByte(serialisedMessage.readPosition());
        if (MessageToTextQueueEntryHandler.isBinaryFormat(dataFormatIndicator)) {
            this.textConversionTarget.clear();
            BinaryWire binaryWire = new BinaryWire(serialisedMessage);
            binaryWire.copyTo((WireOut)new TextWire(this.textConversionTarget));
            text = this.textConversionTarget.toString();
        } else {
            text = serialisedMessage.toString();
        }
        messageHandler.accept(text);
    }

    @Override
    public void close() {
        this.textConversionTarget.release();
    }

    private static boolean isBinaryFormat(byte dataFormatIndicator) {
        return dataFormatIndicator < 0;
    }
}

