/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.function.IntConsumer;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.NewChunkListener;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.PretoucherState;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;

public final class Pretoucher {
    private final SingleChronicleQueue queue;
    private final NewChunkListener chunkListener;
    private final IntConsumer cycleChangedListener;
    private final PretoucherState pretoucherState;
    private int currentCycle = Integer.MIN_VALUE;
    private WireStore currentCycleWireStore;
    private MappedBytes currentCycleMappedBytes;

    public Pretoucher(SingleChronicleQueue queue) {
        this(queue, null, c -> {});
    }

    Pretoucher(SingleChronicleQueue queue, NewChunkListener chunkListener, IntConsumer cycleChangedListener) {
        this.queue = queue;
        this.chunkListener = chunkListener;
        this.cycleChangedListener = cycleChangedListener;
        queue.addCloseListener(this, Pretoucher::releaseResources);
        this.pretoucherState = new PretoucherState(this::getStoreWritePosition);
    }

    public void execute() {
        this.assignCurrentCycle();
        this.pretoucherState.pretouch(this.currentCycleMappedBytes);
    }

    public void shutdown() {
        this.queue.close();
    }

    private void assignCurrentCycle() {
        if (this.queue.cycle() != this.currentCycle) {
            this.releaseResources();
            this.currentCycleWireStore = this.queue.storeForCycle(this.queue.cycle(), this.queue.epoch(), true);
            this.currentCycleMappedBytes = this.currentCycleWireStore.bytes();
            this.currentCycle = this.queue.cycle();
            if (this.chunkListener != null) {
                this.currentCycleMappedBytes.setNewChunkListener(this.chunkListener);
            }
            this.cycleChangedListener.accept(this.queue.cycle());
        }
    }

    private long getStoreWritePosition() {
        return this.currentCycleWireStore.writePosition();
    }

    private void releaseResources() {
        if (this.currentCycleWireStore != null) {
            this.queue.release(this.currentCycleWireStore);
        }
        if (this.currentCycleMappedBytes != null) {
            this.currentCycleMappedBytes.close();
        }
    }
}

