/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class SingleTableStore<T extends Metadata>
implements TableStore<T> {
    public static final String SUFFIX = ".cq4t";
    private static final long timeoutMS = Long.getLong("chronicle.table.store.timeoutMS", 10000L);
    @NotNull
    private final WireType wireType;
    @NotNull
    private final T metadata;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    @NotNull
    private final Wire mappedWire;
    @NotNull
    private final ReferenceCounter refCount;
    private volatile boolean isClosed;

    @UsedViaReflection
    private SingleTableStore(@NotNull WireIn wire) {
        assert (wire.startUse());
        try {
            this.wireType = (WireType)Objects.requireNonNull(wire.read((WireKey)MetaDataField.wireType).object(WireType.class));
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            this.refCount = ReferenceCounter.onReleased(this::onCleanup);
            wire.consumePadding();
            this.metadata = wire.bytes().readRemaining() > 0L ? (Metadata)Objects.requireNonNull(wire.read((WireKey)MetaDataField.metadata).typedMarshallable()) : Metadata.NoMeta.INSTANCE;
            this.mappedWire = (Wire)this.wireType.apply((Object)this.mappedBytes);
        }
        finally {
            assert (wire.endUse());
        }
    }

    SingleTableStore(@NotNull WireType wireType, @NotNull MappedBytes mappedBytes, @NotNull T metadata) {
        this.wireType = wireType;
        this.metadata = metadata;
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.refCount = ReferenceCounter.onReleased(this::onCleanup);
        this.mappedWire = (Wire)wireType.apply((Object)mappedBytes);
    }

    public static <T, R> R doWithSharedLock(File file, Function<T, ? extends R> code, Supplier<T> target) {
        return SingleTableStore.doWithLock(file, code, target, true);
    }

    public static <T, R> R doWithExclusiveLock(File file, Function<T, ? extends R> code, Supplier<T> target) {
        return SingleTableStore.doWithLock(file, code, target, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T, R> R doWithLock(File file, Function<T, ? extends R> code, Supplier<T> target, boolean shared) {
        String type = shared ? "shared" : "exclusive";
        StandardOpenOption readOrWrite = shared ? StandardOpenOption.READ : StandardOpenOption.WRITE;
        long timeoutAt = Time.tickTime() + timeoutMS;
        boolean warnedOnFailure = false;
        try (FileChannel channel = FileChannel.open(file.toPath(), readOrWrite);){
            while (Time.tickTime() < timeoutAt) {
                block22: {
                    try {
                        FileLock fileLock = channel.tryLock(0L, Long.MAX_VALUE, shared);
                        if (fileLock != null) {
                            R r = code.apply(target.get());
                            return r;
                        }
                    }
                    catch (IOException | OverlappingFileLockException e) {
                        if (warnedOnFailure) break block22;
                        String message = "Failed to acquire " + type + " lock on the table store file. Retrying";
                        if (Jvm.isDebugEnabled(SingleTableStore.class)) {
                            Jvm.debug().on(SingleTableStore.class, message, (Throwable)new StackTrace());
                        }
                        warnedOnFailure = true;
                    }
                }
                Time.sleep((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            throw new IllegalStateException("Unable to claim exclusive " + type + " lock on file " + file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't perform operation with " + type + " file lock", e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    @NotNull
    public File file() {
        return this.mappedFile.file();
    }

    @Override
    @NotNull
    public String dump() {
        return this.dump(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dump(boolean abbrev) {
        MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            String string = Wires.fromSizePrefixedBlobs((Bytes)bytes, (boolean)abbrev);
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @Override
    @NotNull
    public String shortDump() {
        return this.dump(true);
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    public boolean tryReserve() {
        return this.refCount.tryReserve();
    }

    public void close() {
        while (this.refCount.get() > 0L) {
            this.refCount.release();
        }
        this.isClosed = true;
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        return MappedBytes.mappedBytes((MappedFile)this.mappedFile);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{wireType=" + this.wireType + ", mappedFile=" + this.mappedFile + ", refCount=" + this.refCount + '}';
    }

    private void onCleanup() {
        this.mappedBytes.release();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MetaDataField.wireType).object((Object)this.wireType);
        if (this.metadata != Metadata.NoMeta.INSTANCE) {
            wire.write((WireKey)MetaDataField.metadata).typedMarshallable(this.metadata);
        }
        wire.writeAlignTo(4, 0);
    }

    @Override
    public synchronized LongValue acquireValueFor(CharSequence key, long defaultValue) {
        StringBuilder sb = Wires.acquireStringBuilder();
        this.mappedBytes.reserve();
        try {
            int header;
            this.mappedBytes.readPosition(0L);
            this.mappedBytes.readLimit(this.mappedBytes.realCapacity());
            while (this.mappedWire.readDataHeader() && !Wires.isNotComplete((int)(header = this.mappedBytes.readVolatileInt()))) {
                long readPosition = this.mappedBytes.readPosition();
                int length = Wires.lengthOf((int)header);
                ValueIn valueIn = this.mappedWire.readEventName(sb);
                if (StringUtils.equalsCaseIgnore((CharSequence)key, (CharSequence)sb)) {
                    LongValue longValue = valueIn.int64ForBinding(null);
                    return longValue;
                }
                this.mappedBytes.readPosition(readPosition + (long)length);
            }
            int safeLength = Maths.toUInt31((long)(this.mappedBytes.realCapacity() - this.mappedBytes.readPosition()));
            this.mappedBytes.writeLimit(this.mappedBytes.realCapacity());
            this.mappedBytes.writePosition(this.mappedBytes.readPosition());
            long pos = this.mappedWire.enterHeader(safeLength);
            LongValue longValue = (LongValue)this.wireType.newLongReference().get();
            this.mappedWire.writeEventName(key).int64forBinding(defaultValue, longValue);
            this.mappedWire.writeAlignTo(4, 0);
            this.mappedWire.updateHeader(pos, false, 0);
            LongValue longValue2 = longValue;
            return longValue2;
        }
        catch (EOFException | StreamCorruptedException e) {
            throw new IORuntimeException((Throwable)e);
        }
        finally {
            this.mappedBytes.release();
        }
    }

    @Override
    public <R> R doWithExclusiveLock(Function<TableStore<T>, ? extends R> code) {
        return SingleTableStore.doWithExclusiveLock(this.file(), code, () -> this);
    }

    @Override
    public T metadata() {
        return this.metadata;
    }
}

