/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import org.jetbrains.annotations.NotNull;

public class TableStoreWriteLock
extends AbstractTSQueueLock
implements WriteLock {
    private static final String LOCK_KEY = "chronicle.write.lock";
    private static final long PID = Jvm.getProcessId();
    private final long timeout;
    private Thread lockedByThread = null;

    public TableStoreWriteLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs, String lockKey) {
        super(lockKey, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    public TableStoreWriteLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs) {
        super(LOCK_KEY, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        this.throwExceptionIfClosed();
        assert (this.checkNotAlreadyLocked());
        long value = 0L;
        try {
            int i = 0;
            value = this.lock.getVolatileValue();
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, PID)) {
                if (i++ > 1000 && Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted for the lock file:" + this.path);
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
                value = this.lock.getVolatileValue();
            }
            assert ((this.lockedByThread = Thread.currentThread()) != null);
        }
        catch (TimeoutException e) {
            String lockedBy = this.getLockedBy(value);
            String warningMsg = "Couldn't acquire write lock after " + this.timeout + " ms for the lock file:" + this.path + ". Lock was held by " + lockedBy;
            if (this.dontRecoverLockTimeout) {
                throw new UnrecoverableTimeoutException(new IllegalStateException(warningMsg));
            }
            Jvm.warn().on(this.getClass(), warningMsg + ". Unlocking forcibly");
            this.forceUnlock(value);
            this.pauser.reset();
            this.lock();
        }
        finally {
            this.pauser.reset();
        }
    }

    @NotNull
    protected String getLockedBy(long value) {
        String lockedBy = value == Long.MIN_VALUE ? "unknown" : (value == PID ? "me" : Long.toString((int)value));
        return lockedBy;
    }

    private boolean checkNotAlreadyLocked() {
        if (this.lockedByThread == null) {
            return true;
        }
        if (this.lockedByThread == Thread.currentThread()) {
            throw new AssertionError((Object)"Lock is already acquired by current thread and is not reentrant - nested document context?");
        }
        return true;
    }

    @Override
    public void unlock() {
        this.throwExceptionIfClosed();
        if (!this.lock.compareAndSwapValue(PID, Long.MIN_VALUE)) {
            long value = this.lock.getValue();
            if (value == Long.MIN_VALUE) {
                Jvm.warn().on(this.getClass(), "Write lock was unlocked by someone else! For the lock file:" + this.path);
            } else {
                Jvm.warn().on(this.getClass(), "Write lock was locked by someone else! For the lock file:" + this.path + " by PID: " + this.getLockedBy(value));
            }
        }
        if (!$assertionsDisabled) {
            this.lockedByThread = null;
            if (null != null) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean locked() {
        this.throwExceptionIfClosed();
        return this.lock.getVolatileValue(Long.MIN_VALUE) != Long.MIN_VALUE;
    }
}

