/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingEventLoop
extends SimpleCloseable
implements EventLoop {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingEventLoop.class);
    @NotNull
    private final EventLoop parent;
    @NotNull
    private final ExecutorService service;
    @NotNull
    private final String name;
    private final AtomicBoolean started = new AtomicBoolean();
    private final List<EventHandler> handlers = new ArrayList<EventHandler>();
    private final NamedThreadFactory threadFactory;
    private final Pauser pauser = Pauser.balanced();

    public BlockingEventLoop(@NotNull EventLoop parent, @NotNull String name) {
        this.name = name;
        this.parent = parent;
        this.threadFactory = new NamedThreadFactory(name);
        this.service = Executors.newCachedThreadPool(this.threadFactory);
    }

    public BlockingEventLoop(@NotNull String name) {
        this.name = name;
        this.parent = this;
        this.threadFactory = new NamedThreadFactory(name);
        this.service = Executors.newCachedThreadPool(this.threadFactory);
    }

    @Override
    public void awaitTermination() {
        try {
            this.service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public synchronized void addHandler(@NotNull EventHandler handler) {
        if (DEBUG_ADDING_HANDLERS) {
            System.out.println("Adding " + (Object)((Object)handler.priority()) + " " + handler + " to " + this.name);
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Event Group has been closed");
        }
        this.handlers.add(handler);
        if (this.started.get()) {
            this.startHandler(handler);
        }
    }

    private String asString(Object handler) {
        return Integer.toHexString(System.identityHashCode(handler));
    }

    @Override
    public synchronized void start() {
        this.started.set(true);
        this.handlers.forEach(this::startHandler);
    }

    private void startHandler(EventHandler handler) {
        try {
            this.service.submit(new Runner(handler));
        }
        catch (RejectedExecutionException e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @Override
    public void unpause() {
        Threads.unpark(this.service);
    }

    @Override
    public void stop() {
        this.service.shutdownNow();
    }

    @Override
    public boolean isAlive() {
        return !this.service.isShutdown();
    }

    @Override
    protected void performClose() {
        super.performClose();
        this.threadFactory.interruptAll();
        Threads.shutdown(this.service);
        if (!this.started.get()) {
            this.handlers.forEach(Threads::loopFinishedQuietly);
        }
        Closeable.closeQuietly(this.handlers);
    }

    public String toString() {
        return "BlockingEventLoop{name=" + this.name + '}';
    }

    private final class Runner
    implements Runnable {
        private final EventHandler handler;

        public Runner(EventHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                BlockingEventLoop.this.throwExceptionIfClosed();
                this.handler.eventLoop(BlockingEventLoop.this.parent);
                this.handler.loopStarted();
                while (!BlockingEventLoop.this.isClosed()) {
                    if (this.handler.action()) {
                        BlockingEventLoop.this.pauser.reset();
                        continue;
                    }
                    BlockingEventLoop.this.pauser.pause();
                }
            }
            catch (InvalidEventHandlerException invalidEventHandlerException) {
            }
            catch (Throwable t) {
                if (!BlockingEventLoop.this.isClosed()) {
                    Jvm.warn().on(this.handler.getClass(), BlockingEventLoop.this.asString(this.handler) + " threw ", t);
                }
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    Jvm.debug().on(this.handler.getClass(), "handler " + BlockingEventLoop.this.asString(this.handler) + " done.");
                }
                Threads.loopFinishedQuietly(this.handler);
            }
        }
    }
}

