/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WriteDocumentContext;
import org.jetbrains.annotations.NotNull;

public class TextWriteDocumentContext
implements WriteDocumentContext {
    protected Wire wire;
    private boolean metaData;
    private volatile boolean notComplete;
    private int count = 0;
    private boolean chainedElement;

    public TextWriteDocumentContext(Wire wire) {
        this.wire = wire;
    }

    @Override
    public void start(boolean metaData) {
        ++this.count;
        if (this.count > 1) {
            assert (metaData == this.isMetaData());
            return;
        }
        this.metaData = metaData;
        if (metaData) {
            this.wire().writeComment("meta-data");
        }
        this.notComplete = true;
        this.chainedElement = false;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void close() {
        if (this.chainedElement) {
            return;
        }
        --this.count;
        if (this.count > 0) {
            return;
        }
        @NotNull Bytes<?> bytes = this.wire().bytes();
        long l = bytes.writePosition();
        if (l < 1L || bytes.peekUnsignedByte(l - 1L) >= 32) {
            bytes.append('\n');
        }
        bytes.append("...\n");
        this.wire().getValueOut().resetBetweenDocuments();
        this.notComplete = false;
    }

    @Override
    public boolean chainedElement() {
        return this.chainedElement;
    }

    @Override
    public void chainedElement(boolean chainedElement) {
        this.chainedElement = chainedElement;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public Wire wire() {
        return this.wire;
    }

    @Override
    public long index() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }
}

