/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.lang.management.ManagementFactory;
import java.util.BitSet;
import net.openhft.affinity.IAffinity;
import net.openhft.affinity.impl.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SolarisJNAAffinity implements IAffinity
{
    INSTANCE;

    private static final Logger LOGGER;
    private final ThreadLocal<Integer> THREAD_ID = new ThreadLocal();

    @Override
    public BitSet getAffinity() {
        return new BitSet();
    }

    @Override
    public void setAffinity(BitSet affinity) {
        LOGGER.trace("unable to set mask to {} as the JNIa nd JNA libraries and not loaded", (Object)Utilities.toHexString(affinity));
    }

    @Override
    public int getCpu() {
        return -1;
    }

    @Override
    public int getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(name.split("@")[0]);
    }

    @Override
    public int getThreadId() {
        Integer tid = this.THREAD_ID.get();
        if (tid == null) {
            tid = CLibrary.INSTANCE.pthread_self();
            tid = tid & 0xFFFFFF;
            this.THREAD_ID.set(tid);
        }
        return tid;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SolarisJNAAffinity.class);
    }

    static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = Native.loadLibrary("c", CLibrary.class);

        public int pthread_self() throws LastErrorException;
    }
}

