/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.writer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;

public class ChronicleWriter {
    private Path basePath;
    private String methodName;
    private List<String> files;

    public void execute() throws IOException {
        try (ChronicleQueue queue = this.createQueue();){
            ExcerptAppender appender = queue.acquireAppender();
            for (String file : this.files) {
                Object payload = Marshallable.fromFile(Object.class, (String)file);
                DocumentContext dc = appender.writingDocument();
                Throwable throwable = null;
                try {
                    dc.wire().write((CharSequence)this.methodName).object(payload);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
        }
    }

    private ChronicleQueue createQueue() {
        return ChronicleQueue.singleBuilder(this.basePath).build();
    }

    public ChronicleWriter withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    public void asMethodWriter(String interfaceName) {
        try {
            Class.forName(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public ChronicleWriter withMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public ChronicleWriter withFiles(List<String> files) {
        this.files = files;
        return this;
    }
}

