/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.writer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;

public class ChronicleWriter {
    private Path basePath;
    private String methodName;
    private List<String> files;
    private Class<?> writeTo;

    public void execute() throws IOException, InvocationTargetException, IllegalAccessException {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder(this.basePath).build();){
            Method method;
            Object mw;
            ExcerptAppender appender = queue.acquireAppender();
            if (this.writeTo != null) {
                mw = appender.methodWriter(this.writeTo, new Class[0]);
                method = Arrays.stream(this.writeTo.getMethods()).filter(m -> m.getName().equals(this.methodName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find method"));
            } else {
                mw = null;
                method = null;
            }
            for (String file : this.files) {
                Object payload = Marshallable.fromFile(Object.class, (String)file);
                DocumentContext dc = appender.writingDocument();
                Throwable throwable = null;
                try {
                    if (mw == null) {
                        dc.wire().write((CharSequence)this.methodName).object(payload);
                        continue;
                    }
                    method.invoke(mw, payload);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
        }
    }

    public ChronicleWriter withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    public ChronicleWriter asMethodWriter(String interfaceName) {
        try {
            this.writeTo = Class.forName(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return this;
    }

    public ChronicleWriter withMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public ChronicleWriter withFiles(List<String> files) {
        this.files = files;
        return this;
    }
}

