/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.rollcycles;

import net.openhft.chronicle.core.Maths;

public final class RollCycleArithmetic {
    private final int cycleShift;
    private final int indexCount;
    private final int indexSpacing;
    private final long sequenceMask;

    public static RollCycleArithmetic of(int indexCount, int indexSpacing) {
        return new RollCycleArithmetic(indexCount, indexSpacing);
    }

    private RollCycleArithmetic(int indexCount, int indexSpacing) {
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        assert (this.indexCount <= 32768) : "indexCount: " + indexCount;
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        this.cycleShift = Math.max(32, Maths.intLog2((long)indexCount) * 2 + Maths.intLog2((long)indexSpacing));
        assert (this.cycleShift < 64) : "cycleShift: " + this.cycleShift;
        this.sequenceMask = (1L << this.cycleShift) - 1L;
    }

    public long maxMessagesPerCycle() {
        return Math.min(this.sequenceMask, (long)this.indexCount * (long)this.indexCount * (long)this.indexSpacing);
    }

    public long toIndex(int cycle, long sequenceNumber) {
        return ((long)cycle << this.cycleShift) + (sequenceNumber & this.sequenceMask);
    }

    public long toSequenceNumber(long index) {
        return index & this.sequenceMask;
    }

    public int toCycle(long index) {
        return Maths.toUInt31((long)(index >> this.cycleShift));
    }

    public int indexSpacing() {
        return this.indexSpacing;
    }

    public int indexCount() {
        return this.indexCount;
    }
}

