/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import jnr.ffi.byref.LongLongByReference;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.salt.Sodium;

public final class Ed25519
extends Enum<Ed25519> {
    public static final int PRIVATE_KEY_LENGTH = 32;
    public static final int PUBLIC_KEY_LENGTH = 32;
    public static final int SECRET_KEY_LENGTH = 64;
    public static final int SIGNATURE_LENGTH = 64;
    private static final ThreadLocal<LocalEd25519> CACHED_CRYPTO;
    private static final /* synthetic */ Ed25519[] $VALUES;

    public static Ed25519[] values() {
        return (Ed25519[])$VALUES.clone();
    }

    public static Ed25519 valueOf(String name) {
        return Enum.valueOf(Ed25519.class, name);
    }

    public static Bytes<Void> allocatePublicKey() {
        return Bytes.allocateDirect((long)32L);
    }

    public static Bytes<Void> allocatePrivateKey() {
        return Bytes.allocateDirect((long)32L);
    }

    public static Bytes<Void> allocateSecretKey() {
        return Bytes.allocateDirect((long)64L);
    }

    public static Bytes<Void> generateRandomBytes(int length) {
        NativeBytes bytes = Bytes.allocateElasticDirect((long)length);
        Sodium.SODIUM.randombytes(bytes.addressForWrite(0L), length);
        bytes.readPositionRemaining(0L, (long)length);
        return bytes;
    }

    public static void privateToPublicAndSecret(Bytes<?> publicKey, Bytes<?> secretKey, BytesStore<?, ?> privateKey) {
        if (privateKey.readRemaining() != 32L) {
            throw new IllegalArgumentException("privateKey");
        }
        assert (privateKey.refCount() > 0);
        assert (secretKey.refCount() > 0);
        assert (publicKey.refCount() > 0);
        publicKey.ensureCapacity(publicKey.writePosition() + 32L);
        secretKey.ensureCapacity(secretKey.writePosition() + 64L);
        assert (privateKey.isDirectMemory());
        assert (secretKey.isDirectMemory());
        assert (publicKey.isDirectMemory());
        long publicKeyAddress = publicKey.addressForWrite(publicKey.writePosition());
        long secretKeyAddress = secretKey.addressForWrite(secretKey.writePosition());
        long seed = privateKey.addressForRead(privateKey.readPosition());
        Sodium.SODIUM.crypto_sign_ed25519_seed_keypair(publicKeyAddress, secretKeyAddress, seed);
        publicKey.readPositionRemaining(publicKey.writePosition(), 32L);
        secretKey.readPositionRemaining(secretKey.writePosition(), 64L);
    }

    public static void sign(BytesStore sigAndMsg, BytesStore<?, ?> secretKey) {
        assert (sigAndMsg.refCount() > 0);
        assert (secretKey.refCount() > 0);
        assert (sigAndMsg.isDirectMemory());
        assert (secretKey.isDirectMemory());
        if (secretKey.readRemaining() != 64L) {
            throw new IllegalArgumentException("Must be a secretKey");
        }
        CACHED_CRYPTO.get().sign(sigAndMsg, secretKey);
    }

    public static void sign(Bytes<?> signature, BytesStore<?, ?> message, BytesStore<?, ?> secretKey) {
        signature.ensureCapacity(signature.writePosition() + 64L + message.readRemaining());
        assert (signature.refCount() > 0);
        assert (message.refCount() > 0);
        assert (secretKey.refCount() > 0);
        assert (signature.isDirectMemory());
        assert (message.isDirectMemory());
        assert (secretKey.isDirectMemory());
        if (secretKey.readRemaining() != 64L) {
            throw new IllegalArgumentException("Must be a secretKey");
        }
        CACHED_CRYPTO.get().sign(signature, message, secretKey);
    }

    public static void sign(BytesStore<?, ?> sigAndMsg, long signatureOffset, long messageOffset, int messageLength, BytesStore<?, ?> secretKey) {
        long maxLength = Math.max(signatureOffset + 64L, messageOffset + (long)messageLength);
        if (sigAndMsg instanceof Bytes) {
            Bytes bytes = (Bytes)sigAndMsg;
            bytes.ensureCapacity(maxLength);
            if (sigAndMsg.readLimit() < maxLength) {
                bytes.writePosition(maxLength);
            }
        } else if (sigAndMsg.writeLimit() < maxLength) {
            throw new IllegalArgumentException();
        }
        assert (sigAndMsg.refCount() > 0);
        assert (secretKey.refCount() > 0);
        assert (sigAndMsg.isDirectMemory());
        assert (secretKey.isDirectMemory());
        if (secretKey.readRemaining() != 64L) {
            throw new IllegalArgumentException("Must be a secretKey");
        }
        CACHED_CRYPTO.get().sign_detached(sigAndMsg, signatureOffset, messageOffset, messageLength, secretKey);
    }

    public static boolean verify(BytesStore<?, ?> sigAndMsg, BytesStore<?, ?> publicKey) {
        assert (sigAndMsg.refCount() > 0);
        assert (publicKey.refCount() > 0);
        assert (sigAndMsg.isDirectMemory());
        assert (publicKey.isDirectMemory());
        if (sigAndMsg.readRemaining() < 64L) {
            throw new IllegalArgumentException("sigAndMsg");
        }
        if (publicKey.readRemaining() != 32L) {
            throw new IllegalArgumentException("publicKey");
        }
        return CACHED_CRYPTO.get().verify(sigAndMsg, publicKey);
    }

    public static boolean verify(BytesStore<?, ?> sigAndMsg, long signatureOffset, long messageOffset, int messageLength, BytesStore<?, ?> publicKey) {
        long maxLength = Math.max(signatureOffset + 64L, messageOffset + (long)messageLength);
        if (sigAndMsg.writeLimit() < maxLength) {
            throw new IllegalArgumentException();
        }
        assert (sigAndMsg.refCount() > 0);
        assert (publicKey.refCount() > 0);
        assert (sigAndMsg.isDirectMemory());
        assert (publicKey.isDirectMemory());
        if (sigAndMsg.readRemaining() < 64L) {
            throw new IllegalArgumentException("sigAndMsg");
        }
        if (publicKey.readRemaining() != 32L) {
            throw new IllegalArgumentException("publicKey");
        }
        return CACHED_CRYPTO.get().verify_detached(sigAndMsg, signatureOffset, messageOffset, messageLength, publicKey);
    }

    public static void generatePrivateKey(Bytes<?> privateKey) {
        assert (privateKey.refCount() > 0);
        privateKey.ensureCapacity(32L);
        assert (privateKey.isDirectMemory());
        long address = privateKey.addressForWrite(0L);
        Sodium.SODIUM.randombytes(address, 32);
        privateKey.readPositionRemaining(0L, 32L);
    }

    public static Bytes<Void> generatePrivateKey() {
        VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
        Ed25519.generatePrivateKey(privateKey);
        return privateKey;
    }

    public static void generatePublicAndSecretKey(Bytes<Void> publicKey, Bytes<Void> secretKey) {
        VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
        try {
            Ed25519.generatePrivateKey(privateKey);
            Ed25519.privateToPublicAndSecret(publicKey, secretKey, privateKey);
        }
        finally {
            privateKey.releaseLast();
        }
    }

    static {
        $VALUES = new Ed25519[0];
        CACHED_CRYPTO = ThreadLocal.withInitial(LocalEd25519::new);
    }

    public static class KeyPair {
        public final Bytes<?> publicKey = Bytes.allocateDirect((long)32L);
        public final Bytes<?> secretKey = Bytes.allocateDirect((long)64L);

        public KeyPair(long id) {
            VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
            privateKey.zeroOut(0L, 32L);
            privateKey.writeLong(24L, id);
            privateKey.writeSkip(32L);
            Ed25519.privateToPublicAndSecret(this.publicKey, this.secretKey, privateKey);
            privateKey.releaseLast();
        }

        public KeyPair(char ch) {
            VanillaBytes privateKey = Bytes.allocateDirect((long)32L);
            while (privateKey.writeRemaining() > 0L) {
                privateKey.append(ch);
            }
            Ed25519.privateToPublicAndSecret(this.publicKey, this.secretKey, privateKey);
            privateKey.releaseLast();
        }
    }

    static class LocalEd25519 {
        @Deprecated
        final LongLongByReference sigLen = new LongLongByReference(0L);
        @Deprecated
        final Bytes<?> buffer = Bytes.allocateElasticDirect((long)64L);

        LocalEd25519() {
        }

        void sign(Bytes<?> sigAndMsg, BytesStore<?, ?> message, BytesStore<?, ?> secretKey) {
            int msgLen = Math.toIntExact(message.readRemaining());
            long signatureAddress = sigAndMsg.addressForWrite(sigAndMsg.writePosition());
            long messageAddress = message.addressForRead(message.readPosition());
            long secretKeyAddress = secretKey.addressForRead(secretKey.readPosition());
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_ed25519(signatureAddress, this.sigLen, messageAddress, msgLen, secretKeyAddress), "Unable to sign");
            long bytesToSkip = this.sigLen.longValue();
            sigAndMsg.writeSkip(bytesToSkip);
        }

        void sign_detached(BytesStore<?, ?> sigAndMsg, long signatureOffset, long messageOffset, int messageLength, BytesStore<?, ?> secretKey) {
            long signatureAddress = sigAndMsg.addressForWrite(signatureOffset);
            long messageAddress = sigAndMsg.addressForRead(messageOffset);
            long secretKeyAddress = secretKey.addressForRead(secretKey.readPosition());
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_ed25519_detached(signatureAddress, 0L, messageAddress, messageLength, secretKeyAddress), "Unable to sign");
        }

        void sign(BytesStore sigAndMsg, BytesStore<?, ?> secretKey) {
            int msgLen = (int)sigAndMsg.readRemaining() - 64;
            long signatureAddress = sigAndMsg.addressForRead(sigAndMsg.readPosition());
            long messageAddress = sigAndMsg.addressForRead(sigAndMsg.readPosition() + 64L);
            long secretKeyAddress = secretKey.addressForRead(secretKey.readPosition());
            Sodium.checkValid(Sodium.SODIUM.crypto_sign_ed25519(signatureAddress, this.sigLen, messageAddress, msgLen, secretKeyAddress), "Unable to sign");
            assert (this.sigLen.longValue() == sigAndMsg.readRemaining());
        }

        boolean verify(BytesStore<?, ?> sigAndMsg, BytesStore<?, ?> publicKey) {
            int length = sigAndMsg.length();
            this.buffer.ensureCapacity((long)length);
            long sigAndMsgAddress = sigAndMsg.addressForRead(sigAndMsg.readPosition());
            long publicKeyAddress = publicKey.addressForRead(publicKey.readLimit() - 32L);
            int ret = Sodium.SODIUM.crypto_sign_ed25519_open(0L, 0L, sigAndMsgAddress, (int)sigAndMsg.readRemaining(), publicKeyAddress);
            return ret == 0;
        }

        boolean verify_detached(BytesStore<?, ?> sigAndMsg, long signatureOffset, long messageOffset, int messageLength, BytesStore<?, ?> publicKey) {
            long publicKeyAddress;
            long messageAddress;
            long signatureAddress = sigAndMsg.addressForRead(signatureOffset);
            int ret = Sodium.SODIUM.crypto_sign_ed25519_verify_detached(signatureAddress, messageAddress = sigAndMsg.addressForRead(messageOffset), messageLength, publicKeyAddress = publicKey.addressForRead(publicKey.readLimit() - 32L));
            return ret == 0;
        }
    }
}

