/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework;

import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.openhft.chronicle.testframework.internal.ProductUtil;

public final class Product {
    private Product() {
    }

    public static <T, U> Stream<Product2<T, U>> of(Collection<T> ts, Collection<U> us) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        return Product.of(ts, us, ProductUtil.Product2Impl::new);
    }

    public static <T, U, R> Stream<R> of(Collection<T> ts, Collection<U> us, BiFunction<? super T, ? super U, ? extends R> constructor) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        Objects.requireNonNull(constructor);
        return ProductUtil.of(ts, us, constructor);
    }

    public static <T, U, V> Stream<Product3<T, U, V>> of(Collection<T> ts, Collection<U> us, Collection<V> vs) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        Objects.requireNonNull(vs);
        return Product.of(ts, us, vs, ProductUtil.Product3Impl::new);
    }

    public static <T, U, V, R> Stream<R> of(Collection<T> ts, Collection<U> us, Collection<V> vs, TriFunction<T, U, V, R> constructor) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        Objects.requireNonNull(vs);
        Objects.requireNonNull(constructor);
        return ProductUtil.of(ts, us, vs, constructor);
    }

    public static interface Product3<T, U, V>
    extends HasFirst<T>,
    HasSecond<U>,
    HasThird<V> {
    }

    public static interface Product2<T, U>
    extends HasFirst<T>,
    HasSecond<U> {
    }

    public static interface HasThird<V> {
        public V third();
    }

    public static interface HasSecond<U> {
        public U second();
    }

    public static interface HasFirst<T> {
        public T first();
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

