/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class PermutationUtil {
    private PermutationUtil() {
    }

    public static long factorial(int n) {
        if (n > 20 || n < 0) {
            throw new IllegalArgumentException(n + " is out of range");
        }
        return LongStream.rangeClosed(2L, n).reduce(1L, (a, b) -> a * b);
    }

    public static <T> List<T> permutation(long no, Collection<T> items) {
        return PermutationUtil.permutationHelper(no, new LinkedList<T>(Objects.requireNonNull(items)), new ArrayList());
    }

    private static <T> List<T> permutationHelper(long no, LinkedList<T> in, List<T> out) {
        if (in.isEmpty()) {
            return out;
        }
        long subFactorial = PermutationUtil.factorial(in.size() - 1);
        out.add(in.remove((int)(no / subFactorial)));
        return PermutationUtil.permutationHelper((int)(no % subFactorial), in, out);
    }

    @SafeVarargs
    public static <T> Stream<List<T>> of(T ... items) {
        return PermutationUtil.of(Arrays.asList(items));
    }

    public static <T> Stream<List<T>> of(Collection<T> items) {
        return LongStream.range(0L, PermutationUtil.factorial(items.size())).mapToObj(no -> PermutationUtil.permutation(no, items));
    }
}

