/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.apimetrics;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.HasName;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.openhft.chronicle.testframework.Product;
import net.openhft.chronicle.testframework.apimetrics.Accumulator;
import net.openhft.chronicle.testframework.apimetrics.Metric;

public final class StandardAccumulator2
implements Accumulator {
    private final String columnName;
    private final Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor;
    private final String columnName2;
    private final Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor2;
    private final Product.TriFunction<Metric<?>, ClassInfo, HasName, Boolean> predicate;
    private final Map<String, Map<String, Double>> map = new HashMap<String, Map<String, Double>>();

    public StandardAccumulator2(String columnName, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor, String columnName2, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor2, Product.TriFunction<Metric<?>, ClassInfo, HasName, Boolean> predicate) {
        this.columnName = Objects.requireNonNull(columnName);
        this.keyExtractor = Objects.requireNonNull(keyExtractor);
        this.columnName2 = Objects.requireNonNull(columnName2);
        this.keyExtractor2 = Objects.requireNonNull(keyExtractor2);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public List<String> aggregationNames() {
        return Arrays.asList(this.columnName, this.columnName2);
    }

    @Override
    public void accept(Metric<?> metric, ClassInfo classInfo, HasName leaf) {
        if (Boolean.TRUE.equals(this.predicate.apply(metric, classInfo, leaf))) {
            String key = this.keyExtractor.apply(metric, classInfo, leaf);
            String key2 = this.keyExtractor2.apply(metric, classInfo, leaf);
            this.map.computeIfAbsent(key, k -> new HashMap()).merge(key2, metric.weight(), Double::sum);
        }
    }

    @Override
    public Double result() {
        return this.map.values().stream().flatMap(m -> m.values().stream()).mapToDouble(d -> d).sum();
    }

    @Override
    public Map<String, Double> result1() {
        return this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).values().stream().mapToDouble(d -> d).sum()));
    }

    @Override
    public Map<String, Map<String, Double>> result2() {
        return Collections.unmodifiableMap(this.map);
    }

    public String toString() {
        int maxCol = this.map.keySet().stream().mapToInt(String::length).max().orElse(10);
        int maxCol2 = this.map.values().stream().flatMap(m -> m.keySet().stream()).mapToInt(String::length).max().orElse(10);
        String formatting = "%-" + maxCol + "s %-" + maxCol2 + "s %12.0f%n";
        return String.format("*Accumulation per %s and %s *%n", this.columnName, this.columnName2) + this.map.entrySet().stream().sorted(Map.Entry.comparingByKey()).flatMap(e -> ((Map)e.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e2 -> String.format(formatting, e.getKey(), e2.getKey(), e2.getValue()))).collect(Collectors.joining()) + String.format(formatting, "_Total_", "", this.result());
    }
}

