/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.apimetrics;

import java.util.Objects;
import java.util.function.Predicate;
import net.openhft.chronicle.testframework.apimetrics.Metric;

public class StandardMetric<T>
implements Metric<T> {
    private final Class<T> nodeType;
    private final Predicate<? super T> filter;
    private final String name;
    private final double weight;

    public StandardMetric(Class<T> nodeType, Predicate<? super T> filter, String name, double weight) {
        this.nodeType = Objects.requireNonNull(nodeType);
        this.filter = Objects.requireNonNull(filter);
        this.name = Objects.requireNonNull(name);
        this.weight = weight;
    }

    @Override
    public Class<T> nodeType() {
        return this.nodeType;
    }

    @Override
    public boolean isApplicable(T node) {
        return this.filter.test(node);
    }

    @Override
    public double weight() {
        return this.weight;
    }

    public String toString() {
        return this.name;
    }
}

