/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.apimetrics;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.HasName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.openhft.chronicle.testframework.Product;
import net.openhft.chronicle.testframework.apimetrics.Accumulator;
import net.openhft.chronicle.testframework.apimetrics.Metric;

public final class StandardAccumulator1
implements Accumulator {
    private final String columnName;
    private final Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor;
    private final Product.TriFunction<Metric<?>, ClassInfo, HasName, Boolean> predicate;
    private final Map<String, Double> map = new HashMap<String, Double>();

    public StandardAccumulator1(String columnName, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor, Product.TriFunction<Metric<?>, ClassInfo, HasName, Boolean> predicate) {
        this.columnName = Objects.requireNonNull(columnName);
        this.keyExtractor = Objects.requireNonNull(keyExtractor);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public List<String> aggregationNames() {
        return Collections.singletonList(this.columnName);
    }

    @Override
    public void accept(Metric<?> metric, ClassInfo classInfo, HasName leaf) {
        if (Boolean.TRUE.equals(this.predicate.apply(metric, classInfo, leaf))) {
            String key = this.keyExtractor.apply(metric, classInfo, leaf);
            this.map.merge(key, metric.weight(), Double::sum);
        }
    }

    @Override
    public Double result() {
        return this.map.values().stream().mapToDouble(d -> d).sum();
    }

    @Override
    public Map<String, Double> result1() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Map<String, Map<String, Double>> result2() {
        throw new UnsupportedOperationException("This aggregation is of level 1");
    }

    public String toString() {
        int maxCol = this.map.keySet().stream().mapToInt(String::length).max().orElse(10);
        String formatting = "%-" + maxCol + "s %12.0f%n";
        return String.format("*Accumulation per %s*%n", this.columnName) + this.map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> String.format(formatting, e.getKey(), e.getValue())).collect(Collectors.joining()) + String.format(formatting, "_Total_", this.result());
    }
}

