/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.dto;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.testframework.internal.dto.DtoTesterBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DtoTester {
    public void test();

    @NotNull
    public static <T> Builder<T> builder(@NotNull Class<T> type, @NotNull Supplier<? extends T> constructor) {
        Objects.requireNonNull(type);
        return new DtoTesterBuilder<T>(type, constructor);
    }

    public static enum MutatorType {
        MANDATORY,
        OPTIONAL;

    }

    public static interface Builder<T> {
        @NotNull
        public <R> Builder<T> withAccessors(@NotNull Function<? super T, ? extends R> var1, @NotNull BiConsumer<? super T, ? super R> var2);

        @NotNull
        public Builder<T> withResetter(@NotNull Consumer<? super T> var1);

        @NotNull
        public Builder<T> withValidator(@NotNull Consumer<? super T> var1);

        @NotNull
        public <R> Builder<T> addMutator(@NotNull MutatorType var1, @NotNull String var2, @NotNull Consumer<? super T> var3);

        @NotNull
        default public <R> Builder<T> addMutator(@NotNull MutatorType mutatorType, @NotNull String mutatorName, @NotNull BiConsumer<? super T, ? super R> setter, @Nullable R value) {
            Objects.requireNonNull(mutatorType);
            Objects.requireNonNull(mutatorName);
            Objects.requireNonNull(setter);
            return this.addMutator(mutatorType, mutatorName, t -> setter.accept((Object)t, (Object)value));
        }

        public DtoTester build();
    }
}

