/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal;

import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.function.Function;
import net.openhft.chronicle.testframework.Delegation;
import org.jetbrains.annotations.NotNull;

public final class DelegationBuilder<T, D>
implements Delegation.Builder<T, D> {
    private final D delegate;
    private Class<T> type = Object.class;
    private Function<? super D, String> toStringFunction = Objects::toString;

    public DelegationBuilder(@NotNull D delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public <N extends D> Delegation.Builder<N, D> as(@NotNull Class<N> type) {
        Objects.requireNonNull(type);
        DelegationBuilder newTypeBuilder = this;
        newTypeBuilder.type = type;
        return newTypeBuilder;
    }

    @Override
    public Delegation.Builder<T, D> toStringFunction(Function<? super D, String> toStringFunction) {
        this.toStringFunction = Objects.requireNonNull(toStringFunction);
        return this;
    }

    @Override
    public T build() {
        return (T)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, (proxy1, method, args) -> {
            if ("toString".equals(method.getName()) && args == null) {
                return this.toStringFunction.apply(this.delegate);
            }
            return method.invoke(this.delegate, args);
        });
    }
}

