/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.network.proxy;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import net.openhft.chronicle.testframework.ThreadUtil;
import net.openhft.chronicle.testframework.internal.network.proxy.ProxyConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpProxy
implements Closeable,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpProxy.class);
    private final InetSocketAddress socketAddress;
    private final InetSocketAddress connectAddress;
    private final ExecutorService executorService;
    private final List<ProxyConnection> connections;
    private volatile boolean running;
    private volatile boolean finished = false;
    private volatile boolean acceptingNewConnections = true;
    private volatile boolean isOpen = false;

    public TcpProxy(int acceptPort, InetSocketAddress connectAddress, ExecutorService executorService) {
        this.connectAddress = connectAddress;
        this.executorService = executorService;
        this.connections = new CopyOnWriteArrayList<ProxyConnection>();
        this.socketAddress = new InetSocketAddress(acceptPort);
    }

    public InetSocketAddress socketAddress() {
        return this.socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        LOGGER.info("Starting proxy on {} proxying to {}", (Object)this.socketAddress, (Object)this.connectAddress);
        try (ServerSocketChannel serverSocket = ServerSocketChannel.open();){
            serverSocket.bind(this.socketAddress, 10);
            serverSocket.configureBlocking(false);
            while (this.running) {
                SocketChannel newConnection;
                this.isOpen = true;
                if (this.acceptingNewConnections && (newConnection = serverSocket.accept()) != null) {
                    LOGGER.info("Received inbound connection from {}", (Object)newConnection.socket().getRemoteSocketAddress());
                    ProxyConnection connection = new ProxyConnection(newConnection, this.connectAddress);
                    this.connections.add(connection);
                    this.executorService.submit(connection);
                }
                for (int i = 0; i < this.connections.size(); ++i) {
                    if (!this.connections.get(i).isFinished()) continue;
                    this.connections.remove(i);
                    --i;
                }
                if (!serverSocket.isOpen()) {
                    throw new IllegalStateException("Server socket not open");
                }
                ThreadUtil.pause(10L);
            }
        }
        catch (Exception e) {
            LOGGER.error("proxy run failed", (Throwable)e);
        }
        finally {
            this.isOpen = false;
        }
        LOGGER.info("TCP proxy from {} proxying to {} terminated", (Object)this.socketAddress, (Object)this.connectAddress);
        this.finished = true;
    }

    public void dropConnectionsAndPauseNewConnections() {
        this.acceptingNewConnections = false;
        this.connections.forEach(ProxyConnection::close);
    }

    public void stopForwardingTrafficAndPauseNewConnections() {
        this.acceptingNewConnections = false;
        this.connections.forEach(ProxyConnection::stopForwardingTraffic);
    }

    public void acceptNewConnections() {
        this.acceptingNewConnections = true;
    }

    @Override
    public void close() throws IllegalStateException {
        this.running = false;
        this.acceptingNewConnections = false;
        this.connections.forEach(ProxyConnection::close);
        while (!this.finished) {
            ThreadUtil.pause(10L);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }
}

