/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.apimetrics;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.HasName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.openhft.chronicle.testframework.Product;
import net.openhft.chronicle.testframework.apimetrics.Metric;
import net.openhft.chronicle.testframework.internal.apimetrics.StandardAccumulator1;
import net.openhft.chronicle.testframework.internal.apimetrics.StandardAccumulator2;
import net.openhft.chronicle.testframework.internal.apimetrics.StandardAccumulators;

public interface Accumulator {
    public List<String> aggregationNames();

    public void accept(Metric<?> var1, ClassInfo var2, HasName var3);

    public Double result();

    public Map<String, Double> result1();

    public Map<String, Map<String, Double>> result2();

    public static Accumulator of(String columnName, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor) {
        Objects.requireNonNull(columnName);
        Objects.requireNonNull(keyExtractor);
        return Accumulator.of(columnName, keyExtractor, (m, ci, l) -> true);
    }

    public static Accumulator of(String columnName, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor, Product.TriFunction<Metric<?>, ClassInfo, HasName, Boolean> predicate) {
        Objects.requireNonNull(columnName);
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(predicate);
        return new StandardAccumulator1(columnName, keyExtractor, predicate);
    }

    public static Accumulator of(String columnName, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor, String columnName2, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor2) {
        Objects.requireNonNull(columnName);
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(columnName2);
        Objects.requireNonNull(keyExtractor2);
        return Accumulator.of(columnName, keyExtractor, columnName2, keyExtractor2, (m, ci, l) -> true);
    }

    public static Accumulator of(String columnName, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor, String columnName2, Product.TriFunction<Metric<?>, ClassInfo, HasName, String> keyExtractor2, Product.TriFunction<Metric<?>, ClassInfo, HasName, Boolean> predicate) {
        Objects.requireNonNull(columnName);
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(columnName2);
        Objects.requireNonNull(keyExtractor2);
        Objects.requireNonNull(predicate);
        return new StandardAccumulator2(columnName, keyExtractor, columnName2, keyExtractor2, predicate);
    }

    public static Supplier<Accumulator> perMethod() {
        return StandardAccumulators.PER_METHOD;
    }

    public static Supplier<Accumulator> perClassAndMetric() {
        return StandardAccumulators.PER_CLASS_AND_METRIC;
    }
}

