/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.apimetrics;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.HasName;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.openhft.chronicle.testframework.apimetrics.Accumulator;
import net.openhft.chronicle.testframework.apimetrics.ApiMetrics;
import net.openhft.chronicle.testframework.apimetrics.Metric;
import net.openhft.chronicle.testframework.internal.apimetrics.StandardAccumulators;
import net.openhft.chronicle.testframework.internal.apimetrics.StandardApiMetrics;
import net.openhft.chronicle.testframework.internal.apimetrics.StandardMetrics;

public final class StandardApiMetricsBuilder
implements ApiMetrics.ApiMetricsBuilder {
    private final List<String> packageNames = new ArrayList<String>();
    private final List<String> packageNameExclusions = new ArrayList<String>();
    private final Map<Class<?>, Set<Metric<?>>> metrics = new HashMap();
    private final Set<Accumulator> accumulators = new LinkedHashSet<Accumulator>();
    private final Set<Accumulator> internalAccumulators = new LinkedHashSet<Accumulator>();

    @Override
    public StandardApiMetricsBuilder addPackage(String packageName) {
        Objects.requireNonNull(packageName);
        this.packageNames.add(packageName);
        return this;
    }

    @Override
    public ApiMetrics.ApiMetricsBuilder addPackageExclusion(String paketName) {
        Objects.requireNonNull(paketName);
        this.packageNameExclusions.add(paketName);
        return this;
    }

    @Override
    public ApiMetrics.ApiMetricsBuilder addMetric(Metric<?> metric) {
        Objects.requireNonNull(metric);
        this.metrics.computeIfAbsent(metric.nodeType(), nt -> Collections.newSetFromMap(new IdentityHashMap())).add(metric);
        return this;
    }

    @Override
    public ApiMetrics.ApiMetricsBuilder addStandardMetrics() {
        StandardMetrics.stream().forEach(this::addMetric);
        return this;
    }

    @Override
    public ApiMetrics.ApiMetricsBuilder addAccumulator(Supplier<Accumulator> accumulator) {
        Objects.requireNonNull(accumulator);
        this.accumulators.add(Objects.requireNonNull(accumulator.get()));
        return this;
    }

    @Override
    public ApiMetrics.ApiMetricsBuilder addStandardAccumulators() {
        StandardAccumulators.stream().forEach(this::addAccumulator);
        return this;
    }

    @Override
    public ApiMetrics build() {
        if (this.metrics.isEmpty()) {
            throw new IllegalStateException("No Metrics provided");
        }
        ClassInfoList.ClassInfoFilter filter = ci -> !ci.getPackageName().contains(".internal.") && !ci.getPackageName().contains(".internal");
        this.computeFor(this.accumulators, filter);
        ClassInfoList.ClassInfoFilter internalFilter = ci -> ci.getPackageName().contains(".internal.") || ci.getPackageName().contains(".internal");
        this.computeFor(this.internalAccumulators, internalFilter);
        return new StandardApiMetrics(this.accumulators, this.internalAccumulators);
    }

    private void computeFor(Set<Accumulator> accumulators, ClassInfoList.ClassInfoFilter filter) {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().enableAllInfo().scan();){
            ClassInfoList exposedClassInfoList = scanResult.getAllClasses().filter(filter).filter(ci -> this.packageNames.stream().anyMatch(pn -> ci.getPackageInfo().getName().startsWith((String)pn))).filter(ci -> this.packageNameExclusions.stream().noneMatch(pn -> ci.getPackageInfo().getName().startsWith((String)pn)));
            exposedClassInfoList.forEach(ci -> {
                this.accumulateApplicableMetrics(accumulators, (ClassInfo)ci);
                ci.getMethodInfo().forEach(mi -> this.accumulateApplicableMetrics(accumulators, (MethodInfo)mi));
                ci.getFieldInfo().forEach(fi -> this.accumulateApplicableMetrics(accumulators, (FieldInfo)fi));
            });
        }
    }

    void accumulateApplicableMetrics(Set<Accumulator> accumulators, FieldInfo fieldInfo) {
        this.metricsFor(FieldInfo.class).stream().filter(m -> m.isApplicable(fieldInfo)).forEach(m -> this.accumulate(accumulators, (Metric<?>)m, fieldInfo.getClassInfo(), (HasName)fieldInfo));
    }

    void accumulateApplicableMetrics(Set<Accumulator> accumulators, MethodInfo methodInfo) {
        this.metricsFor(MethodInfo.class).stream().filter(m -> m.isApplicable(methodInfo)).forEach(m -> this.accumulate(accumulators, (Metric<?>)m, methodInfo.getClassInfo(), (HasName)methodInfo));
    }

    void accumulateApplicableMetrics(Set<Accumulator> accumulators, ClassInfo classInfo) {
        this.metricsFor(ClassInfo.class).stream().filter(m -> m.isApplicable(classInfo)).forEach(m -> this.accumulate(accumulators, (Metric<?>)m, classInfo, (HasName)classInfo));
    }

    void accumulate(Set<Accumulator> accumulators, Metric<?> metric, ClassInfo classInfo, HasName leaf) {
        accumulators.forEach(a -> a.accept(metric, classInfo, leaf));
    }

    private <T> Set<Metric<T>> metricsFor(Class<T> nodeType) {
        return this.metrics.getOrDefault(nodeType, Collections.emptySet());
    }
}

