/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.network.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import net.openhft.chronicle.testframework.CloseableUtil;
import net.openhft.chronicle.testframework.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConnection
implements Closeable,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConnection.class);
    private final SocketChannel inboundChannel;
    private final InetSocketAddress remoteAddress;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
    private volatile boolean running = true;
    private volatile boolean finished = false;
    private volatile boolean forwardingTraffic = true;

    public ProxyConnection(SocketChannel inboundChannel, InetSocketAddress remoteAddress) {
        this.inboundChannel = inboundChannel;
        this.remoteAddress = remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        try (SocketChannel outboundChannel = SelectorProvider.provider().openSocketChannel();){
            outboundChannel.configureBlocking(true);
            outboundChannel.connect(this.remoteAddress);
            LOGGER.info("Established connection between {} and {}", (Object)this.inboundChannel.socket().getRemoteSocketAddress(), (Object)outboundChannel.socket().getRemoteSocketAddress());
            outboundChannel.configureBlocking(false);
            this.inboundChannel.configureBlocking(false);
            while (this.running) {
                if (this.forwardingTraffic) {
                    this.relayTraffic(this.inboundChannel, outboundChannel);
                    this.relayTraffic(outboundChannel, this.inboundChannel);
                    continue;
                }
                ThreadUtil.pause(10L);
            }
            LOGGER.info("Terminating connection between {} and {}", (Object)this.inboundChannel.socket().getRemoteSocketAddress(), (Object)outboundChannel.socket().getRemoteSocketAddress());
        }
        catch (IOException e) {
            LOGGER.error("Connection failed", (Throwable)e);
        }
        finally {
            CloseableUtil.closeQuietly(this.inboundChannel);
        }
        this.finished = true;
    }

    private void relayTraffic(SocketChannel sourceChannel, SocketChannel destinationChannel) throws IOException {
        this.byteBuffer.clear();
        int read = sourceChannel.read(this.byteBuffer);
        if (read > 0) {
            this.byteBuffer.flip();
            destinationChannel.write(this.byteBuffer);
        }
    }

    @Override
    public void close() throws IllegalStateException {
        this.running = false;
        while (!this.finished) {
            ThreadUtil.pause(10L);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void stopForwardingTraffic() {
        this.forwardingTraffic = false;
    }
}

