/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.mappedfiles;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MappedFileUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(MappedFileUtil.class);
    private static final Path PROC_SELF_MAPS = Paths.get("/proc/self/maps", new String[0]);
    private static final Pattern LINE_PATTERN = Pattern.compile("([\\p{XDigit}\\-]+)\\s+([rwxsp\\-]+)\\s+(\\p{XDigit}+)\\s+(\\p{XDigit}+:\\p{XDigit}+)\\s+(\\d+)(?:\\s+(.*))?");
    private static final int ADDRESS_INDEX = 1;
    private static final int PERMS_INDEX = 2;
    private static final int OFFSET_INDEX = 3;
    private static final int DEV_INDEX = 4;
    private static final int INODE_INDEX = 5;
    private static final int PATH_INDEX = 6;

    public static Set<String> getAllMappedFiles() {
        HashSet<String> fileList = new HashSet<String>();
        if (Files.exists(PROC_SELF_MAPS, new LinkOption[0]) && Files.isReadable(PROC_SELF_MAPS)) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(PROC_SELF_MAPS, new OpenOption[0])));){
                MappedFileUtil.processProcSelfMaps(fileList, reader);
            }
            catch (IOException e) {
                throw new IllegalStateException("Getting mapped files failed", e);
            }
            return fileList;
        }
        throw new UnsupportedOperationException(String.format("This only works on systems that have a /proc/self/maps (exists=%s, isReadable=%s)", Files.exists(PROC_SELF_MAPS, new LinkOption[0]), Files.isReadable(PROC_SELF_MAPS)));
    }

    private static void processProcSelfMaps(Set<String> fileList, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            Matcher matcher = MappedFileUtil.parseMapsLine(line);
            if (matcher.matches()) {
                MappedFileUtil.processOneLine(fileList, matcher);
                continue;
            }
            LOGGER.warn("Found non-matching line in /proc/self/maps: {}", (Object)line);
        }
    }

    private static void processOneLine(Set<String> fileList, Matcher matcher) {
        String filename = MappedFileUtil.getPath(matcher);
        if (filename == null) {
            return;
        }
        if (filename.startsWith("/")) {
            fileList.add(filename);
        } else if (!filename.trim().isEmpty()) {
            LOGGER.debug("Ignoring non-file {}", (Object)filename);
        }
    }

    public static Matcher parseMapsLine(String line) {
        return LINE_PATTERN.matcher(line);
    }

    @Nullable
    public static String getPath(Matcher matcher) {
        return matcher.group(6);
    }

    public static String getAddress(Matcher matcher) {
        return matcher.group(1);
    }
}

