/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.openhft.chronicle.testframework.ThreadUtil;

public class Waiters {
    private static final int DEFAULT_MAX_WAIT_TIME_MS = 5000;
    private static final int DEFAULT_CHECK_INTERVAL_MS = 10;
    private static final Predicate<Boolean> IDENTITY = t -> t;
    private static final String DEFAULT_BOOLEAN_MESSAGE = "Condition not met";
    private static final String DEFAULT_GENERIC_MESSAGE = "Condition not met, lastValue = %s";

    public static void waitForCondition(String message, Supplier<Boolean> condition, long maxTimeToWaitMs) {
        Waiters.builder(condition).message(message).maxTimeToWaitMs(maxTimeToWaitMs).run();
    }

    public static WaiterBuilder<Boolean> builder(Supplier<Boolean> condition) {
        return Waiters.builder(condition, IDENTITY).message(DEFAULT_BOOLEAN_MESSAGE);
    }

    public static <T> WaiterBuilder<T> builder(Supplier<T> valueSupplier, Predicate<T> conditionTester) {
        return new WaiterBuilder(valueSupplier, conditionTester);
    }

    public static class ConditionNotMetException
    extends RuntimeException {
        private static final long serialVersionUID = 2827672436814649510L;
        private final Object lastValue;

        ConditionNotMetException(Object lastValue, String message) {
            super(message);
            this.lastValue = lastValue;
        }

        public Object lastValue() {
            return this.lastValue;
        }
    }

    public static class WaiterBuilder<T>
    implements Runnable {
        private final Supplier<T> valueSupplier;
        private final Predicate<T> conditionTester;
        private long maxTimeToWaitMs = 5000L;
        private long checkIntervalMs = 10L;
        private Function<T, String> messageGenerator = lastValue -> String.format(Waiters.DEFAULT_GENERIC_MESSAGE, lastValue);

        private WaiterBuilder(Supplier<T> valueSupplier, Predicate<T> conditionTester) {
            this.valueSupplier = valueSupplier;
            this.conditionTester = conditionTester;
        }

        @Override
        public void run() {
            T value;
            long endTime = System.currentTimeMillis() + this.maxTimeToWaitMs;
            while (!this.conditionTester.test(value = this.valueSupplier.get())) {
                if (System.currentTimeMillis() > endTime) {
                    throw new ConditionNotMetException(value, this.messageGenerator.apply(value));
                }
                ThreadUtil.pause(this.checkIntervalMs);
            }
        }

        public WaiterBuilder<T> message(String message) {
            this.messageGenerator = lastValue -> message;
            return this;
        }

        public WaiterBuilder<T> messageGenerator(Function<T, String> messageGenerator) {
            this.messageGenerator = messageGenerator;
            return this;
        }

        public WaiterBuilder<T> maxTimeToWaitMs(long maxTimeToWaitMs) {
            this.maxTimeToWaitMs = maxTimeToWaitMs;
            return this;
        }

        public WaiterBuilder<T> checkIntervalMs(long checkIntervalMs) {
            this.checkIntervalMs = checkIntervalMs;
            return this;
        }
    }
}

