/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.testframework.Product;

public final class ProductUtil {
    private ProductUtil() {
    }

    public static <T, U, R> Stream<R> of(Collection<T> ts, Collection<U> us, BiFunction<? super T, ? super U, ? extends R> constructor) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        Objects.requireNonNull(constructor);
        return ts.stream().flatMap(t -> us.stream().map(u -> constructor.apply(t, u)));
    }

    public static <T, U, R> Stream<R> of(Stream<T> ts, Stream<U> us, BiFunction<? super T, ? super U, ? extends R> constructor) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        Objects.requireNonNull(constructor);
        List innerU = us.collect(Collectors.toList());
        return ts.flatMap(t -> innerU.stream().map(u -> constructor.apply(t, u)));
    }

    public static <T, U, V, R> Stream<R> of(Collection<T> ts, Collection<U> us, Collection<V> vs, Product.TriFunction<? super T, ? super U, ? super V, ? extends R> constructor) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        Objects.requireNonNull(vs);
        Objects.requireNonNull(constructor);
        return ts.stream().flatMap(t -> us.stream().flatMap(u -> vs.stream().map(v -> constructor.apply(t, u, v))));
    }

    public static <T, U, V, R> Stream<R> of(Stream<T> ts, Stream<U> us, Stream<V> vs, Product.TriFunction<? super T, ? super U, ? super V, ? extends R> constructor) {
        Objects.requireNonNull(ts);
        Objects.requireNonNull(us);
        Objects.requireNonNull(vs);
        Objects.requireNonNull(constructor);
        List innerU = us.collect(Collectors.toList());
        List innerV = vs.collect(Collectors.toList());
        return ts.flatMap(t -> innerU.stream().flatMap(u -> innerV.stream().map(v -> constructor.apply(t, u, v))));
    }

    public static final class Product3Impl<T, U, V>
    implements Product.Product3<T, U, V> {
        private final T first;
        private final U second;
        private final V third;

        public Product3Impl(T first, U second, V third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        @Override
        public T first() {
            return this.first;
        }

        @Override
        public U second() {
            return this.second;
        }

        @Override
        public V third() {
            return this.third;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Product3Impl product3 = (Product3Impl)o;
            if (!Objects.equals(this.first, product3.first)) {
                return false;
            }
            if (!Objects.equals(this.second, product3.second)) {
                return false;
            }
            return Objects.equals(this.third, product3.third);
        }

        public int hashCode() {
            int result = this.first != null ? this.first.hashCode() : 0;
            result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
            result = 31 * result + (this.third != null ? this.third.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Product3Impl{first=" + this.first + ", second=" + this.second + ", third=" + this.third + '}';
        }
    }

    public static final class Product2Impl<T, U>
    implements Product.Product2<T, U> {
        private final T first;
        private final U second;

        public Product2Impl(T first, U second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public T first() {
            return this.first;
        }

        @Override
        public U second() {
            return this.second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Product2Impl product2 = (Product2Impl)o;
            if (!Objects.equals(this.first, product2.first)) {
                return false;
            }
            return Objects.equals(this.second, product2.second);
        }

        public int hashCode() {
            int result = this.first != null ? this.first.hashCode() : 0;
            result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Product2Impl{first=" + this.first + ", second=" + this.second + '}';
        }
    }
}

