/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.testframework.FlakyTestRunner;
import net.openhft.chronicle.testframework.ThreadUtil;
import net.openhft.chronicle.testframework.internal.VanillaFlakyTestRunnerBuilder;

public final class VanillaFlakyTestRunner<X extends Throwable>
implements FlakyTestRunner.RunnableThrows<X> {
    private final AtomicBoolean inRun = new AtomicBoolean();
    private final VanillaFlakyTestRunnerBuilder<X> builder;

    public VanillaFlakyTestRunner(VanillaFlakyTestRunnerBuilder<X> builder) {
        this.builder = Objects.requireNonNull(builder);
    }

    @Override
    public void run() throws X {
        if (!this.inRun.compareAndSet(false, true)) {
            throw new AssertionError((Object)"Can't run nested");
        }
        try {
            for (int i = 0; i < this.builder.maxIterations; ++i) {
                try {
                    this.builder.action.run();
                    if (i > 0) {
                        this.builder.infoLogger.accept("Flaky test threw an error " + i + " run(s), but passed on run " + (i + 1));
                    }
                    break;
                }
                catch (Throwable x) {
                    if (i == this.builder.maxIterations - 1) {
                        throw x;
                    }
                    this.builder.errorLogger.accept("Rerunning failing test run " + (i + 2));
                    if (this.builder.interIterationGc) {
                        System.gc();
                    }
                    ThreadUtil.pause(this.builder.delayMs);
                    continue;
                }
            }
        }
        finally {
            this.inRun.set(false);
        }
    }
}

