/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.apimetrics;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.testframework.apimetrics.Accumulator;
import net.openhft.chronicle.testframework.apimetrics.ApiMetrics;

public final class StandardApiMetrics
implements ApiMetrics {
    private final Set<Accumulator> accumulators;
    private final Set<Accumulator> internalAccumulators;

    public StandardApiMetrics(Set<Accumulator> accumulators, Set<Accumulator> internalAccumulators) {
        Objects.requireNonNull(accumulators);
        Objects.requireNonNull(internalAccumulators);
        this.accumulators = new LinkedHashSet<Accumulator>(accumulators);
        this.internalAccumulators = new LinkedHashSet<Accumulator>(internalAccumulators);
    }

    @Override
    public Stream<Accumulator> accumulators() {
        return this.accumulators.stream();
    }

    @Override
    public Stream<Accumulator> internalAccumulators() {
        return this.internalAccumulators.stream();
    }

    public String toString() {
        return this.accumulators.stream().map(Objects::toString).collect(Collectors.joining(String.format("%n", new Object[0])));
    }
}

