/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.codestructure;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.CompositeArchRule;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import net.openhft.chronicle.testframework.internal.codestructure.rules.DtoAliasMustInvokeBootstrapRuleSupplier;
import net.openhft.chronicle.testframework.internal.codestructure.rules.MainMethodRuleSupplier;
import net.openhft.chronicle.testframework.internal.codestructure.rules.NonInternalClassesMustNotExtendInternalClassesRuleSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeStructureVerifier {
    private static final Logger log = LoggerFactory.getLogger(CodeStructureVerifier.class);
    private final JavaClasses javaClasses;
    private final Set<ArchRule> rules;

    private CodeStructureVerifier(JavaClasses javaClasses, Set<ArchRule> rules) {
        if (javaClasses == null) {
            throw new IllegalArgumentException("Cannot set up test runner with no classes");
        }
        this.javaClasses = javaClasses;
        if (rules == null || rules.isEmpty()) {
            throw new IllegalArgumentException("Cannot set up test runner with no rules");
        }
        this.rules = rules;
    }

    public void verify() {
        log.info("Running code structure test with the following rules: {}", this.rules);
        CompositeArchRule compositeArchRule = CompositeArchRule.of(this.rules);
        compositeArchRule.check(this.javaClasses);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<ImportOption> importOptions = new HashSet<ImportOption>();
        private final Set<ArchRule> rulesToSkip = new HashSet<ArchRule>();
        private final Set<ArchRule> rules = new HashSet<ArchRule>();
        private final Set<String> classesToExclude = new HashSet<String>();
        private Class<?> clazz;
        private String[] packages;

        public Builder withRule(ArchRule rule) {
            if (rule == null) {
                throw new NullPointerException("rule cannot be null");
            }
            this.rules.add(rule);
            return this;
        }

        public Builder skipRule(ArchRule rule) {
            if (rule == null) {
                throw new NullPointerException("rule cannot be null");
            }
            this.rulesToSkip.add(rule);
            return this;
        }

        public Builder skipTests() {
            this.importOptions.add((ImportOption)new ImportOption.DoNotIncludeTests());
            return this;
        }

        public Builder importClass(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz cannot be null");
            }
            this.clazz = clazz;
            return this;
        }

        public Builder importPackages(String ... packages) {
            if (packages == null || packages.length == 0) {
                throw new IllegalArgumentException("Cannot import empty packages");
            }
            this.packages = packages;
            return this;
        }

        private static String parseClassName(URI fileUri) {
            Path path = Paths.get(fileUri);
            Path relativePath = path.subpath(path.getNameCount() - 7, path.getNameCount());
            String classNamePath = relativePath.toString().replace(".class", "");
            String className = classNamePath.replace('/', '.').replace('\\', '.');
            className = className.replaceFirst("^target\\.classes\\.", "");
            className = className.replaceFirst("^test-classes\\.", "");
            return className;
        }

        public Builder skipClass(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz cannot be null");
            }
            this.classesToExclude.add(clazz.getName());
            return this;
        }

        private void installDefaultRules() {
            this.rules.add(new MainMethodRuleSupplier().get());
            this.rules.add(new NonInternalClassesMustNotExtendInternalClassesRuleSupplier().get());
            this.rules.add(new DtoAliasMustInvokeBootstrapRuleSupplier().get());
        }

        private JavaClasses getJavaClasses() {
            this.skipClasses();
            ClassFileImporter classFileImporter = new ClassFileImporter(this.importOptions);
            if (this.clazz != null) {
                return classFileImporter.importClasses(new Class[]{this.clazz});
            }
            if (this.packages != null && this.packages.length > 0) {
                return classFileImporter.importPackages(this.packages);
            }
            throw new IllegalArgumentException("Cannot build test runner with no packages");
        }

        private void skipClasses() {
            this.importOptions.add(location -> {
                String className = Builder.parseClassName(location.asURI());
                return !this.classesToExclude.contains(className);
            });
        }

        private void skipRules() {
            for (ArchRule ruleToSkip : this.rulesToSkip) {
                this.rules.removeIf(rule -> rule.getDescription().equals(ruleToSkip.getDescription()));
            }
        }

        public CodeStructureVerifier build() {
            this.installDefaultRules();
            this.skipRules();
            JavaClasses javaClasses = this.getJavaClasses();
            return new CodeStructureVerifier(javaClasses, this.rules);
        }
    }
}

