/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.codestructure.rules;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DtoAliasMustInvokeBootstrapRuleSupplier
implements Supplier<ArchRule> {
    @Override
    public ArchRule get() {
        return ((GivenClassesConjunction)ArchRuleDefinition.classes().that().haveSimpleName("DtoAlias")).should((ArchCondition)new ContainsStaticBlockCallingBootstrap()).allowEmptyShould(true);
    }

    private static class ContainsStaticBlockCallingBootstrap
    extends ArchCondition<JavaClass> {
        public static final String CORE_BOOTSTRAP_METHOD_TARGET = "net.openhft.chronicle.core.Bootstrap.bootstrap()";

        public ContainsStaticBlockCallingBootstrap() {
            super("contain a static block that calls bootstrap appropriately", new Object[0]);
        }

        public void check(JavaClass javaClass, ConditionEvents conditionEvents) {
            Set codeUnits = javaClass.getCodeUnits();
            List<JavaCodeUnit> staticBlocks = codeUnits.stream().filter(codeUnit -> codeUnit.getClass().isAssignableFrom(JavaStaticInitializer.class)).collect(Collectors.toList());
            long coreBootstrapCount = ContainsStaticBlockCallingBootstrap.getMethodInvocationsFromCodeUnits(staticBlocks, CORE_BOOTSTRAP_METHOD_TARGET);
            String samePackageBootstrapClass = javaClass.getPackageName() + ".Bootstrap.bootstrap()";
            long samePackageBootstrapCount = ContainsStaticBlockCallingBootstrap.getMethodInvocationsFromCodeUnits(staticBlocks, samePackageBootstrapClass);
            conditionEvents.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, coreBootstrapCount == 1L, String.format("The class %s does not contain one call to %s", javaClass.getName(), CORE_BOOTSTRAP_METHOD_TARGET)));
            conditionEvents.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, samePackageBootstrapCount == 1L, String.format("The class %s does not contain one call to %s", javaClass.getName(), samePackageBootstrapClass)));
        }

        private static long getMethodInvocationsFromCodeUnits(List<JavaCodeUnit> codeUnits, String methodTarget) {
            long totalCount = 0L;
            for (JavaCodeUnit staticBlock : codeUnits) {
                long callCount = staticBlock.getMethodCallsFromSelf().stream().filter(javaMethodCall -> {
                    AccessTarget.MethodCallTarget target = (AccessTarget.MethodCallTarget)javaMethodCall.getTarget();
                    return target.getFullName().equals(methodTarget);
                }).count();
                totalCount += callCount;
            }
            return totalCount;
        }
    }
}

