/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.codestructure.rules;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaParameter;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MainMethodRuleSupplier
implements Supplier<ArchRule> {
    @Override
    public ArchRule get() {
        return ((GivenClassesConjunction)ArchRuleDefinition.classes().that().containAnyMethodsThat((DescribedPredicate)new MainMethodPredicate())).should((ArchCondition)new ContainsStaticBlockCondition()).allowEmptyShould(true);
    }

    private static class ContainsStaticBlockCondition
    extends ArchCondition<JavaClass> {
        public ContainsStaticBlockCondition() {
            super("contain a static block that calls DtoAlias.init()", new Object[0]);
        }

        public void check(JavaClass javaClass, ConditionEvents conditionEvents) {
            Set codeUnits = javaClass.getCodeUnits();
            List staticBlocks = codeUnits.stream().filter(codeUnit -> codeUnit.getClass().isAssignableFrom(JavaStaticInitializer.class)).collect(Collectors.toList());
            long totalCount = 0L;
            for (JavaCodeUnit staticBlock : staticBlocks) {
                long appropriateStaticCallCount = staticBlock.getMethodCallsFromSelf().stream().filter(javaMethodCall -> {
                    AccessTarget.MethodCallTarget target = (AccessTarget.MethodCallTarget)javaMethodCall.getTarget();
                    return target.getFullName().endsWith("DtoAlias.init()");
                }).count();
                totalCount += appropriateStaticCallCount;
            }
            conditionEvents.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, totalCount == 1L, String.format("The class %s does not contain exactly one static block that calls DtoAlias.init()", javaClass.getName())));
        }
    }

    private static class MainMethodPredicate
    extends DescribedPredicate<JavaMethod> {
        public MainMethodPredicate() {
            super("are static main methods", new Object[0]);
        }

        public boolean test(JavaMethod javaMethod) {
            boolean isCalledMain = javaMethod.getName().equals("main");
            boolean isStatic = javaMethod.getModifiers().contains(JavaModifier.STATIC);
            boolean hasSingleParameter = javaMethod.getParameters().size() == 1;
            boolean hasCorrectParameterType = hasSingleParameter && ((JavaParameter)javaMethod.getParameters().get(0)).getRawType().isAssignableFrom(String[].class);
            return isCalledMain && isStatic && hasSingleParameter && hasCorrectParameterType;
        }
    }
}

