/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.internal.codestructure.rules;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.util.function.Supplier;

public class NonInternalClassesMustNotExtendInternalClassesRuleSupplier
implements Supplier<ArchRule> {
    @Override
    public ArchRule get() {
        return ((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().resideOutsideOfPackage("..internal..")).and().resideOutsideOfPackage("..impl..")).should((ArchCondition)new ArchCondition<JavaClass>("not extend internal classes", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                if (javaClass.getSuperclass().isPresent()) {
                    String fullName = ((JavaType)javaClass.getSuperclass().get()).getName();
                    boolean packageIsInternal = fullName.matches(".*\\.(impl|internal)\\..*");
                    events.add((ConditionEvent)new SimpleConditionEvent((Object)javaClass, !packageIsInternal, String.format("The non-internal class %s extends internal class %s", javaClass.getName(), fullName)));
                }
            }
        }).allowEmptyShould(true);
    }
}

