/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.testframework.process;

import java.util.Objects;
import net.openhft.chronicle.testframework.internal.process.InternalJavaProcessBuilder;
import org.jetbrains.annotations.NotNull;

public interface JavaProcessBuilder {
    public JavaProcessBuilder withProgramArguments(String ... var1);

    public JavaProcessBuilder withJvmArguments(String ... var1);

    public JavaProcessBuilder withClasspathEntries(String ... var1);

    public JavaProcessBuilder inheritingIO();

    public Process start();

    public static JavaProcessBuilder create(@NotNull Class<?> mainClass) {
        Objects.requireNonNull(mainClass);
        return new InternalJavaProcessBuilder(mainClass);
    }

    public static void printProcessOutput(String processName, Process process) {
        Objects.requireNonNull(processName);
        Objects.requireNonNull(process);
        InternalJavaProcessBuilder.printProcessOutput(processName, process);
    }

    public static String getProcessStdErr(Process process) {
        Objects.requireNonNull(process);
        return InternalJavaProcessBuilder.getProcessStdErr(process);
    }

    public static String getProcessStdOut(Process process) {
        Objects.requireNonNull(process);
        return InternalJavaProcessBuilder.getProcessStdOut(process);
    }
}

